/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.FontIcon;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import de.gurkenlabs.litiengine.gui.Slider;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class VerticalSlider
extends Slider {
    public static final FontIcon ARROW_DOWN = new FontIcon(ICON_FONT, "\ue804");
    public static final FontIcon ARROW_UP = new FontIcon(ICON_FONT, "\ue807");
    private double minSliderY;
    private double maxSliderY;

    public VerticalSlider(double x, double y, double width, double height, float minValue, float maxValue, float stepSize, Spritesheet buttonSprite, Spritesheet sliderSprite, boolean showArrowButtons) {
        super(x, y, width, height, minValue, maxValue, stepSize, buttonSprite, sliderSprite, showArrowButtons);
    }

    @Override
    public Point2D getRelativeSliderPosition() {
        return new Point2D.Double(this.getX(), this.minSliderY + (double)(this.getCurrentValue() / (this.getMaxValue() - this.getMinValue())) * (this.maxSliderY - this.minSliderY));
    }

    @Override
    public void prepare() {
        if (this.arrowButtonsShown()) {
            this.setButton1(new ImageComponent(this.getX(), this.getY(), this.getWidth(), this.getWidth(), this.getButtonSprite(), ARROW_UP.getText(), null));
            this.getButton1().setFont(ARROW_UP.getFont());
            this.setButton2(new ImageComponent(this.getX(), this.getY() + this.getHeight() - this.getWidth(), this.getWidth(), this.getWidth(), this.getButtonSprite(), ARROW_DOWN.getText(), null));
            this.getButton2().setFont(ARROW_DOWN.getFont());
            this.getComponents().add(this.getButton1());
            this.getComponents().add(this.getButton2());
        }
        double sliderHeight = (this.getHeight() - this.getWidth() * 2.0) * 1.0 / 6.0;
        this.minSliderY = this.getY() + this.getWidth();
        this.maxSliderY = this.getY() + this.getHeight() - (this.getWidth() + sliderHeight);
        this.setSlider(new ImageComponent(this.getRelativeSliderPosition().getX(), this.getRelativeSliderPosition().getY(), this.getWidth(), sliderHeight, this.getSliderSprite(), "", null));
        this.getComponents().add(this.getSliderComponent());
        super.prepare();
    }

    @Override
    public void render(Graphics2D g) {
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke((float)(this.getWidth() / 8.0)));
        g.setColor(this.getAppearance().getForeColor());
        g.drawLine((int)(this.getX() + this.getWidth() / 2.0), (int)this.minSliderY, (int)(this.getX() + this.getWidth() / 2.0), (int)(this.getY() + this.getHeight() - this.getWidth()));
        g.setStroke(oldStroke);
        super.render(g);
    }

    @Override
    public void setValueRelativeToMousePosition() {
        double mouseY = Input.mouse().getLocation().getY();
        if (mouseY >= this.minSliderY && mouseY <= this.maxSliderY) {
            double relativeMouseX = mouseY - this.minSliderY;
            double percentage = relativeMouseX / (this.maxSliderY - this.minSliderY);
            this.setCurrentValue((float)((double)this.getMinValue() + percentage * (double)(this.getMaxValue() - this.getMinValue())));
        }
    }
}

