/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.graphics.ShapeRenderer;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.GuiComponent;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import de.gurkenlabs.litiengine.gui.VerticalSlider;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class ListField
extends GuiComponent {
    private boolean arrowKeyNavigation;
    private Spritesheet buttonSprite;
    private Spritesheet entrySprite;
    private final List<Consumer<Integer>> changeConsumer = new CopyOnWriteArrayList<Consumer<Integer>>();
    private final Object[] contents;
    private final CopyOnWriteArrayList<ImageComponent> listEntries;
    private int lowerBound = 0;
    private ImageComponent selectedComponent;
    private int selection;
    private final int shownElements;
    private VerticalSlider slider;

    public ListField(double x, double y, double width, double height, Object[] content, int shownElements, Spritesheet entrySprite, Spritesheet buttonSprite) {
        super(x, y, width, height);
        this.contents = content;
        this.listEntries = new CopyOnWriteArrayList();
        this.buttonSprite = buttonSprite;
        this.entrySprite = entrySprite;
        this.shownElements = shownElements;
        this.initContentList();
        this.prepareInput();
    }

    public Spritesheet getButtonSprite() {
        return this.buttonSprite;
    }

    public List<Consumer<Integer>> getChangeConsumer() {
        return this.changeConsumer;
    }

    public Object[] getContentArray() {
        return this.contents;
    }

    public Spritesheet getEntrySprite() {
        return this.entrySprite;
    }

    public List<ImageComponent> getListEntries() {
        return this.listEntries;
    }

    public ImageComponent getListEntry(int listIndex) {
        if (listIndex <= 0 || listIndex > this.listEntries.size()) {
            return null;
        }
        return this.listEntries.get(listIndex);
    }

    public int getLowerBound() {
        return this.lowerBound;
    }

    public int getNumberOfShownElements() {
        return this.shownElements;
    }

    public ImageComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public Object getSelectedObject() {
        return this.getContentArray()[this.getSelection()];
    }

    public int getSelection() {
        return this.selection;
    }

    public VerticalSlider getSlider() {
        return this.slider;
    }

    public boolean isArrowKeyNavigation() {
        return this.arrowKeyNavigation;
    }

    public void onChange(Consumer<Integer> c) {
        this.getChangeConsumer().add(c);
    }

    @Override
    public void suspend() {
        super.suspend();
    }

    @Override
    public void prepare() {
        super.prepare();
    }

    public void refresh() {
        for (int i = 0; i < this.getNumberOfShownElements(); ++i) {
            if (this.getContentArray().length <= i || this.getListEntry(i) == null) continue;
            this.getListEntry(i).setText(this.getContentArray()[i + this.getLowerBound()].toString());
        }
        if (this.getSelection() >= this.getLowerBound() && this.getSelection() < this.getLowerBound() + this.getNumberOfShownElements()) {
            this.selectedComponent = this.getListEntry(this.getSelection() - this.getLowerBound());
            if (this.selectedComponent != null) {
                this.selectedComponent.setSelected(true);
            }
        } else {
            this.selectedComponent = null;
        }
    }

    @Override
    public void render(Graphics2D g) {
        super.render(g);
        if (this.selectedComponent != null) {
            Rectangle2D.Double border = new Rectangle2D.Double(this.selectedComponent.getX() - 1.0, this.selectedComponent.getY() - 1.0, this.selectedComponent.getWidth() + 2.0, this.selectedComponent.getHeight() + 2.0);
            g.setColor(Color.WHITE);
            ShapeRenderer.renderOutline(g, (Shape)border, 2.0f);
        }
    }

    public void setArrowKeyNavigation(boolean arrowKeyNavigation) {
        this.arrowKeyNavigation = arrowKeyNavigation;
    }

    public void setButtonSprite(Spritesheet buttonSprite) {
        this.buttonSprite = buttonSprite;
    }

    public void setEntrySprite(Spritesheet entrySprite) {
        this.entrySprite = entrySprite;
    }

    public void setLowerBound(int lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setSelection(int selection) {
        if (selection < 0 || selection >= this.contents.length) {
            return;
        }
        this.selection = selection;
        if (this.getSelection() >= this.getLowerBound() + this.getNumberOfShownElements()) {
            this.setLowerBound(this.getLowerBound() + 1);
        } else if (this.getSelection() < this.getLowerBound() && this.getLowerBound() > 0) {
            this.setLowerBound(this.getLowerBound() - 1);
        }
        this.getChangeConsumer().forEach(consumer -> consumer.accept(this.getSelection()));
        this.refresh();
    }

    private void initContentList() {
        int sliderMax;
        boolean showButtons = false;
        if (this.buttonSprite != null) {
            showButtons = true;
        }
        if ((sliderMax = this.getContentArray().length - this.getNumberOfShownElements()) > 0) {
            this.slider = new VerticalSlider(this.getX() + this.getWidth(), this.getY(), this.getHeight() / (double)this.getNumberOfShownElements(), this.getHeight(), 0.0f, sliderMax, 1.0f, this.buttonSprite, this.buttonSprite, showButtons);
            this.getSlider().setCurrentValue(this.getLowerBound());
            this.getComponents().add(this.getSlider());
        }
        for (int i = 0; i < this.getNumberOfShownElements(); ++i) {
            if (this.getContentArray().length <= i) continue;
            ImageComponent entryComponent = this.getContentArray()[i] == null ? new ImageComponent(this.getX(), this.getY() + this.getHeight() / (double)this.getNumberOfShownElements() * (double)i, this.getWidth(), this.getHeight() / (double)this.getNumberOfShownElements(), this.entrySprite, "", null) : new ImageComponent(this.getX(), this.getY() + this.getHeight() / (double)this.getNumberOfShownElements() * (double)i, this.getWidth(), this.getHeight() / (double)this.getNumberOfShownElements(), this.entrySprite, this.contents[i].toString(), null);
            entryComponent.setTextAlignment(Align.LEFT);
            this.getListEntries().add(entryComponent);
        }
        this.getComponents().addAll(this.getListEntries());
        for (ImageComponent comp : this.getListEntries()) {
            comp.onClicked(e -> {
                this.setSelection(this.getLowerBound() + this.getListEntries().indexOf(comp) % this.getNumberOfShownElements());
                this.refresh();
            });
        }
        this.onChange(s -> {
            if (this.getSlider() != null) {
                this.getSlider().setCurrentValue(this.getLowerBound());
                this.getSlider().getSliderComponent().setLocation(this.getSlider().getRelativeSliderPosition());
            }
        });
        if (this.getSlider() != null) {
            this.getSlider().onChange((Float sliderValue) -> {
                this.setLowerBound(sliderValue.intValue());
                this.getSlider().getSliderComponent().setLocation(this.getSlider().getRelativeSliderPosition());
                this.refresh();
            });
        }
    }

    private void prepareInput() {
        Input.keyboard().onKeyTyped(38, e -> {
            if (this.isSuspended() || !this.isVisible() || !this.isArrowKeyNavigation()) {
                return;
            }
            this.setSelection(this.getSelection() - 1);
        });
        Input.keyboard().onKeyTyped(40, e -> {
            if (this.isSuspended() || !this.isVisible() || !this.isArrowKeyNavigation()) {
                return;
            }
            this.setSelection(this.getSelection() + 1);
        });
        this.onMouseWheelScrolled(e -> {
            if (this.isSuspended() || !this.isVisible()) {
                return;
            }
            if (this.isHovered()) {
                if (e.getEvent().getWheelRotation() < 0) {
                    this.setSelection(this.getSelection() - 1);
                } else {
                    this.setSelection(this.getSelection() + 1);
                }
                return;
            }
        });
    }
}

