/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.gui;

import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.GuiComponent;
import de.gurkenlabs.litiengine.gui.ImageComponent;
import java.awt.Image;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ImageComponentList
extends GuiComponent {
    private final Spritesheet background;
    private final List<ImageComponent> cells;
    private List<Image> images;
    private final double rowHeight;
    private final double columnWidth;
    private final int rows;
    private final int columns;
    private double xOffset;
    private double yOffset;
    private boolean initialized;

    public ImageComponentList(double x, double y, double width, double height, int rows, int columns, List<Image> images, Spritesheet background) {
        super(x, y, width, height);
        if (images != null) {
            this.images = images;
        } else {
            this.images = new CopyOnWriteArrayList<Image>();
            this.images.add(null);
        }
        this.background = background;
        this.cells = new CopyOnWriteArrayList<ImageComponent>();
        this.rows = rows;
        this.columns = columns;
        if (this.getRows() == 1) {
            this.rowHeight = this.getHeight();
            this.yOffset = 0.0;
        } else {
            this.rowHeight = this.getHeight() / (double)this.getRows() * 9.0 / 10.0;
            this.yOffset = this.getHeight() / (double)(this.getRows() - 1) * 1.0 / 10.0;
        }
        if (this.getColumns() == 1) {
            this.columnWidth = this.getWidth();
            this.xOffset = 0.0;
        } else {
            this.columnWidth = this.getWidth() / (double)this.getColumns() * 9.0 / 10.0;
            this.xOffset = this.getWidth() / (double)(this.getColumns() - 1) * 1.0 / 10.0;
        }
    }

    public Spritesheet getBackground() {
        return this.background;
    }

    public List<ImageComponent> getCellComponents() {
        return this.cells;
    }

    public int getColumns() {
        return this.columns;
    }

    public List<Image> getImages() {
        return this.images;
    }

    public int getRows() {
        return this.rows;
    }

    @Override
    public void prepare() {
        if (!this.initialized) {
            int imageCount = -1;
            for (int j = 0; j < this.getRows(); ++j) {
                for (int i = 0; i < this.getColumns(); ++i) {
                    Image img = imageCount < this.getImages().size() - 1 ? this.getImages().get(++imageCount) : null;
                    ImageComponent cell = this.createNewEntry(this.getX() + (double)i * (this.columnWidth + this.xOffset), this.getY() + (double)j * (this.rowHeight + this.yOffset), this.columnWidth, this.rowHeight, this.getBackground(), "", img);
                    this.cells.add(cell);
                }
            }
            this.getComponents().addAll(this.cells);
            this.initialized = true;
        }
        super.prepare();
    }

    protected ImageComponent createNewEntry(double x, double y, double width, double height, Spritesheet spritesheet, String text, Image image) {
        return new ImageComponent(x, y, width, height, spritesheet, text, image);
    }

    public void setXOffset(double xOffset) {
        this.xOffset = xOffset;
        this.suspend();
        this.prepare();
    }

    public void setYOffset(double yOffset) {
        this.yOffset = yOffset;
        this.suspend();
        this.prepare();
    }
}

