/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters.xml;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.graphics.emitters.particles.ParticleType;
import de.gurkenlabs.litiengine.graphics.emitters.xml.ParticleColor;
import de.gurkenlabs.litiengine.graphics.emitters.xml.ParticleParameter;
import de.gurkenlabs.litiengine.physics.CollisionType;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import de.gurkenlabs.litiengine.util.MathUtilities;
import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="emitter")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EmitterData
implements Serializable,
Comparable<EmitterData> {
    private static final long serialVersionUID = 50238884097993529L;
    @XmlElementWrapper(name="colors")
    @XmlElement(name="color")
    private List<ParticleColor> colors;
    @XmlElement
    private ParticleParameter deltaHeight;
    @XmlElement
    private ParticleParameter deltaWidth;
    @XmlElement
    private ParticleParameter deltaX;
    @XmlElement
    private ParticleParameter deltaY;
    @XmlAttribute
    private int emitterTTL;
    @XmlElement
    private ParticleParameter gravityX;
    @XmlElement
    private ParticleParameter gravityY;
    @XmlAttribute
    private float height;
    @XmlAttribute
    private int maxParticles;
    @XmlAttribute
    private String name;
    @XmlElement
    private ParticleParameter particleHeight;
    @XmlAttribute
    private int particleMaxTTL;
    @XmlAttribute
    private int particleMinTTL;
    @XmlElement
    private String particleText;
    @XmlAttribute
    private ParticleType particleType;
    @XmlElement
    private ParticleParameter particleWidth;
    @XmlAttribute
    private int spawnAmount;
    @XmlAttribute
    private int spawnRate;
    @XmlAttribute
    private int updateRate;
    @XmlAttribute
    private float width;
    @XmlElement
    private float colorDeviation;
    @XmlElement
    private float alphaDeviation;
    @XmlElement
    private ParticleParameter x;
    @XmlElement
    private ParticleParameter y;
    @XmlElement
    private boolean animateSprite;
    @XmlElement
    private String spritesheet;
    @XmlElement
    private String colorProbabilities;
    @XmlElement
    private Align originAlign;
    @XmlElement
    private Valign originValign;
    @XmlElement
    private CollisionType collisionType;
    @XmlElement
    private boolean fade;

    public EmitterData() {
        this.colors = new ArrayList<ParticleColor>();
        this.x = new ParticleParameter();
        this.y = new ParticleParameter();
        this.deltaX = new ParticleParameter();
        this.deltaY = new ParticleParameter();
        this.gravityX = new ParticleParameter();
        this.gravityY = new ParticleParameter();
        this.particleWidth = new ParticleParameter();
        this.particleHeight = new ParticleParameter();
        this.deltaWidth = new ParticleParameter();
        this.deltaHeight = new ParticleParameter();
        this.colorDeviation = 0.0f;
        this.alphaDeviation = 0.0f;
        this.collisionType = CollisionType.NONE;
        this.updateRate = 30;
        this.originValign = Valign.TOP;
        this.originAlign = Align.LEFT;
        this.fade = true;
    }

    public EmitterData(EmitterData data) {
        this.colors = data.colors;
        this.colorProbabilities = data.colorProbabilities;
        this.x = data.x;
        this.y = data.y;
        this.deltaHeight = data.deltaHeight;
        this.deltaWidth = data.deltaWidth;
        this.deltaX = data.deltaX;
        this.deltaY = data.deltaY;
        this.emitterTTL = data.emitterTTL;
        this.gravityX = data.gravityX;
        this.gravityY = data.gravityY;
        this.width = data.width;
        this.height = data.height;
        this.particleWidth = data.particleWidth;
        this.particleHeight = data.particleHeight;
        this.colorDeviation = data.colorDeviation;
        this.alphaDeviation = data.alphaDeviation;
        this.updateRate = data.updateRate;
        this.collisionType = data.collisionType;
        this.maxParticles = data.maxParticles;
        this.name = data.name;
        this.particleMinTTL = data.particleMinTTL;
        this.particleMaxTTL = data.particleMaxTTL;
        this.particleText = data.particleText;
        this.particleType = data.particleType;
        this.spawnAmount = data.spawnAmount;
        this.spawnRate = data.spawnRate;
        this.animateSprite = data.animateSprite;
        this.spritesheet = data.spritesheet;
        this.originValign = data.getOriginValign();
        this.originAlign = data.getOriginAlign();
        this.fade = data.fade;
    }

    @Override
    public int compareTo(EmitterData obj) {
        if (obj == null) {
            return 1;
        }
        if (this.getName() == null) {
            if (obj.getName() == null) {
                return 0;
            }
            return -1;
        }
        return this.getName().compareTo(obj.getName());
    }

    @XmlTransient
    public float getColorDeviation() {
        return this.colorDeviation;
    }

    @XmlTransient
    public float getAlphaDeviation() {
        return this.alphaDeviation;
    }

    @XmlTransient
    public List<ParticleColor> getColors() {
        return this.colors;
    }

    @XmlTransient
    public ParticleParameter getDeltaHeight() {
        return this.deltaHeight;
    }

    @XmlTransient
    public ParticleParameter getDeltaWidth() {
        return this.deltaWidth;
    }

    @XmlTransient
    public ParticleParameter getDeltaX() {
        return this.deltaX;
    }

    @XmlTransient
    public ParticleParameter getDeltaY() {
        return this.deltaY;
    }

    @XmlTransient
    public int getEmitterTTL() {
        return this.emitterTTL;
    }

    @XmlTransient
    public ParticleParameter getGravityX() {
        return this.gravityX;
    }

    @XmlTransient
    public ParticleParameter getGravityY() {
        return this.gravityY;
    }

    @XmlTransient
    public float getHeight() {
        return this.height;
    }

    @XmlTransient
    public int getMaxParticles() {
        return this.maxParticles;
    }

    @XmlTransient
    public String getName() {
        return this.name;
    }

    @XmlTransient
    public Align getOriginAlign() {
        return this.originAlign;
    }

    public Valign getOriginValign() {
        return this.originValign;
    }

    @XmlTransient
    public ParticleParameter getParticleHeight() {
        return this.particleHeight;
    }

    @XmlTransient
    public int getParticleMaxTTL() {
        return this.particleMaxTTL;
    }

    @XmlTransient
    public int getParticleMinTTL() {
        return this.particleMinTTL;
    }

    @XmlTransient
    public String getParticleText() {
        return this.particleText;
    }

    @XmlTransient
    public ParticleType getParticleType() {
        return this.particleType;
    }

    @XmlTransient
    public ParticleParameter getParticleWidth() {
        return this.particleWidth;
    }

    @XmlTransient
    public ParticleParameter getParticleX() {
        return this.x;
    }

    @XmlTransient
    public ParticleParameter getParticleY() {
        return this.y;
    }

    @XmlTransient
    public int getSpawnAmount() {
        return this.spawnAmount;
    }

    @XmlTransient
    public CollisionType getCollisionType() {
        return this.collisionType;
    }

    @XmlTransient
    public int getSpawnRate() {
        return this.spawnRate;
    }

    public boolean isAnimateSprite() {
        return this.animateSprite;
    }

    public boolean isFading() {
        return this.fade;
    }

    public void setAnimateSprite(boolean animateSprite) {
        this.animateSprite = animateSprite;
    }

    @XmlTransient
    public String getSpritesheet() {
        return this.spritesheet;
    }

    public void setSpritesheet(String spritesheet) {
        this.spritesheet = spritesheet;
    }

    @XmlTransient
    public int getUpdateRate() {
        return this.updateRate;
    }

    @XmlTransient
    public float getWidth() {
        return this.width;
    }

    @XmlTransient
    public double[] getColorProbabilities() {
        return ArrayUtilities.getDoubleArray(this.colorProbabilities);
    }

    public void setColorProbabilities(double[] colorProbabilities) {
        this.colorProbabilities = ArrayUtilities.getCommaSeparatedString(colorProbabilities);
    }

    public void setColorProbabilities(String colorProbabilities) {
        this.colorProbabilities = colorProbabilities;
    }

    public void setColors(List<ParticleColor> colors) {
        this.colors = colors;
    }

    public void setColor(Color color) {
        ArrayList<ParticleColor> tmpList = new ArrayList<ParticleColor>();
        tmpList.add(new ParticleColor(color));
        this.colors = tmpList;
    }

    public void setAlphaDeviation(float alphaDeviation) {
        this.alphaDeviation = MathUtilities.clamp(alphaDeviation, 0.0f, 1.0f);
    }

    public void setColorDeviation(float colorDeviation) {
        this.colorDeviation = MathUtilities.clamp(colorDeviation, 0.0f, 1.0f);
    }

    public void setDeltaHeight(ParticleParameter deltaHeight) {
        this.deltaHeight = deltaHeight;
    }

    public void setDeltaWidth(ParticleParameter deltaWidth) {
        this.deltaWidth = deltaWidth;
    }

    public void setDeltaX(ParticleParameter deltaX) {
        this.deltaX = deltaX;
    }

    public void setDeltaY(ParticleParameter deltaY) {
        this.deltaY = deltaY;
    }

    public void setEmitterTTL(int emitterTTL) {
        this.emitterTTL = emitterTTL;
    }

    public void setFade(boolean fade) {
        this.fade = fade;
    }

    public void setGravityX(ParticleParameter gravityX) {
        this.gravityX = gravityX;
    }

    public void setGravityY(ParticleParameter gravityY) {
        this.gravityY = gravityY;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setMaxParticles(int maxParticles) {
        this.maxParticles = maxParticles;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOriginAlign(Align align) {
        this.originAlign = align;
    }

    public void setOriginValign(Valign valign) {
        this.originValign = valign;
    }

    public void setParticleHeight(ParticleParameter particleHeight) {
        this.particleHeight = particleHeight;
    }

    public void setParticleMaxTTL(int particleMaxTTL) {
        this.particleMaxTTL = particleMaxTTL;
    }

    public void setParticleMinTTL(int particleMinTTL) {
        this.particleMinTTL = particleMinTTL;
    }

    public void setParticleText(String particleText) {
        this.particleText = particleText;
    }

    public void setParticleType(ParticleType particleType) {
        this.particleType = particleType;
    }

    public void setParticleWidth(ParticleParameter particleWidth) {
        this.particleWidth = particleWidth;
    }

    public void setCollisionType(CollisionType physics) {
        this.collisionType = physics;
    }

    public void setSpawnAmount(int spawnAmount) {
        this.spawnAmount = spawnAmount;
    }

    public void setSpawnRate(int spawnRate) {
        this.spawnRate = spawnRate;
    }

    public void setUpdateRate(int updateRate) {
        if (updateRate == 0) {
            return;
        }
        this.updateRate = updateRate;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setParticleX(ParticleParameter x) {
        this.x = x;
    }

    public void setParticleY(ParticleParameter y) {
        this.y = y;
    }
}

