/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics.emitters;

import de.gurkenlabs.litiengine.annotation.EmitterInfo;
import de.gurkenlabs.litiengine.annotation.EntityInfo;
import de.gurkenlabs.litiengine.graphics.emitters.Emitter;
import de.gurkenlabs.litiengine.graphics.emitters.particles.Particle;
import de.gurkenlabs.litiengine.graphics.emitters.particles.RectangleFillParticle;
import java.awt.Color;
import java.awt.geom.Point2D;

@EntityInfo(width=32.0f, height=64.0f)
@EmitterInfo(maxParticles=200, spawnAmount=200, activateOnInit=true, particleMinTTL=300, particleMaxTTL=1200)
public class FireEmitter
extends Emitter {
    private static final Color DARK_ORANGE = new Color(208, 117, 29, 100);
    private static final Color GOLD = new Color(246, 206, 72, 100);
    private static final Color REDISH_BROWN = new Color(159, 70, 24, 100);
    private static final Color YELLOW = new Color(251, 239, 169, 100);
    private static final int REDISH_BROWN_COUNT = 10;
    private static final int DARK_ORANGE_COUNT = 7;
    private static final int GOLD_COUNT = 5;
    private static final int YELLOW_COUNT = 2;
    private static final int NEW_PARTICLE_COUNT = 24;

    public FireEmitter(int originX, int originY) {
        super((double)originX, originY);
    }

    @Override
    public Point2D getLocation() {
        return new Point2D.Double(super.getLocation().getX(), super.getLocation().getY() + (double)this.getHeight());
    }

    public void newParticle(Color color, int life, double maxAxisMovement) {
        boolean randBool = Math.random() >= 0.5;
        float x = (float)((double)this.getWidth() * 0.5 + Math.random() * maxAxisMovement * (double)(randBool ? -1.0f : 1.0f));
        float dx = (float)(Math.random() * 0.2);
        float dy = (float)(Math.random() * 2.0 * -1.0);
        float gravityY = 0.0015f * (randBool ? 1.0f : -1.0f);
        float size = (float)(4.0 + Math.random() * 5.0);
        this.addParticle(new RectangleFillParticle(size, size, color, life).setX(x).setDeltaX(dx).setDeltaY(dy).setDeltaIncY(gravityY));
    }

    @Override
    protected Particle createNewParticle() {
        return null;
    }

    @Override
    protected void spawnParticle() {
        int i;
        if (this.getParticles().size() > this.getMaxParticles() - 24) {
            return;
        }
        for (i = 0; i < 10; i = (int)((byte)(i + 1))) {
            this.newParticle(REDISH_BROWN, this.getParticleMaxTTL(), this.getWidth() / 4.0f);
        }
        for (i = 0; i < 7; i = (int)((byte)(i + 1))) {
            this.newParticle(DARK_ORANGE, this.getRandomParticleTTL(), this.getWidth() / 5.0f);
        }
        for (i = 0; i < 5; i = (int)((byte)(i + 1))) {
            this.newParticle(GOLD, this.getRandomParticleTTL(), this.getWidth() / 6.0f);
        }
        for (i = 0; i < 2; i = (int)((byte)(i + 1))) {
            this.newParticle(YELLOW, this.getParticleMinTTL(), this.getWidth() / 7.0f);
        }
    }
}

