/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.entities.StaticShadow;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.graphics.ColorLayer;
import de.gurkenlabs.litiengine.graphics.StaticShadowType;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;

public class StaticShadowLayer
extends ColorLayer {
    public StaticShadowLayer(IEnvironment env, int alpha, Color color) {
        super(env, color, alpha);
    }

    @Override
    protected void renderSection(Graphics2D g, Rectangle2D section) {
        Color colorWithAlpha = this.getColorWithAlpha();
        g.setColor(colorWithAlpha);
        Area ar = new Area();
        for (StaticShadow staticShadow : this.getEnvironment().getStaticShadows()) {
            if (!staticShadow.getBoundingBox().intersects(section) || staticShadow.getShadowType() == StaticShadowType.NONE) continue;
            Area staticShadowArea = staticShadow.getArea();
            ar.add(staticShadowArea);
        }
        ar.transform(AffineTransform.getTranslateInstance(-section.getX(), -section.getY()));
        g.fill(ar);
    }
}

