/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.EntityYComparator;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapRenderer;
import de.gurkenlabs.litiengine.environment.tilemap.MapOrientation;
import de.gurkenlabs.litiengine.environment.tilemap.OrthogonalMapRenderer;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.graphics.RenderEvent;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.ShapeRenderer;
import de.gurkenlabs.litiengine.graphics.animation.IEntityAnimationController;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class RenderEngine {
    public static final float DEFAULT_RENDERSCALE = 3.0f;
    private final EntityYComparator entityComparator;
    private final List<Consumer<RenderEvent<IEntity>>> entityRenderedConsumer = new CopyOnWriteArrayList<Consumer<RenderEvent<IEntity>>>();
    private final List<Predicate<IEntity>> entityRenderingConditions;
    private final List<Consumer<RenderEvent<IEntity>>> entityRenderingConsumer = new CopyOnWriteArrayList<Consumer<RenderEvent<IEntity>>>();
    private final EnumMap<MapOrientation, IMapRenderer> mapRenderer;
    private float baseRenderScale;

    public RenderEngine() {
        this.entityRenderingConditions = new CopyOnWriteArrayList<Predicate<IEntity>>();
        this.mapRenderer = new EnumMap(MapOrientation.class);
        this.entityComparator = new EntityYComparator();
        this.mapRenderer.put(MapOrientation.ORTHOGONAL, new OrthogonalMapRenderer());
        this.baseRenderScale = 3.0f;
    }

    public void renderText(Graphics2D g, String text, double x, double y) {
        if (text == null || text.isEmpty()) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        Point2D viewPortLocation = Game.getCamera().getViewPortLocation(x, y);
        g.drawString(text, (float)viewPortLocation.getX() * Game.getCamera().getRenderScale(), (float)viewPortLocation.getY() * Game.getCamera().getRenderScale());
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
    }

    public void renderText(Graphics2D g, String text, Point2D location) {
        this.renderText(g, text, location.getX(), location.getY());
    }

    public void renderShape(Graphics2D g, Shape shape) {
        if (shape == null) {
            return;
        }
        AffineTransform t = new AffineTransform();
        t.scale(Game.getCamera().getRenderScale(), Game.getCamera().getRenderScale());
        t.translate(Game.getCamera().getPixelOffsetX(), Game.getCamera().getPixelOffsetY());
        ShapeRenderer.renderTransformed(g, shape, t);
    }

    public void renderOutline(Graphics2D g, Shape shape) {
        this.renderOutline(g, shape, new BasicStroke(1.0f / Game.getCamera().getRenderScale()));
    }

    public void renderOutline(Graphics2D g, Shape shape, Stroke stroke) {
        if (shape == null) {
            return;
        }
        AffineTransform t = new AffineTransform();
        t.scale(Game.getCamera().getRenderScale(), Game.getCamera().getRenderScale());
        t.translate(Game.getCamera().getPixelOffsetX(), Game.getCamera().getPixelOffsetY());
        ShapeRenderer.renderOutlineTransformed(g, shape, t, stroke);
    }

    public boolean canRender(IEntity entity) {
        if (!this.entityRenderingConditions.isEmpty()) {
            for (Predicate<IEntity> consumer : this.entityRenderingConditions) {
                if (consumer.test(entity)) continue;
                return false;
            }
        }
        return true;
    }

    public void entityRenderingCondition(Predicate<IEntity> predicate) {
        if (!this.entityRenderingConditions.contains(predicate)) {
            this.entityRenderingConditions.add(predicate);
        }
    }

    public float getBaseRenderScale() {
        return this.baseRenderScale;
    }

    public IMapRenderer getMapRenderer(MapOrientation mapOrientation) {
        if (!this.mapRenderer.containsKey((Object)mapOrientation)) {
            throw new IllegalArgumentException("The map orientation " + (Object)((Object)mapOrientation) + " is not supported!");
        }
        return this.mapRenderer.get((Object)mapOrientation);
    }

    public void onEntityRendered(Consumer<RenderEvent<IEntity>> entity) {
        if (!this.entityRenderedConsumer.contains(entity)) {
            this.entityRenderedConsumer.add(entity);
        }
    }

    public void onEntityRendering(Consumer<RenderEvent<IEntity>> entity) {
        if (!this.entityRenderingConsumer.contains(entity)) {
            this.entityRenderingConsumer.add(entity);
        }
    }

    public void render(Graphics2D g, Collection<? extends IRenderable> renderables) {
        renderables.forEach(r -> this.render(g, (IRenderable)r));
    }

    public void render(Graphics2D g, Collection<? extends IRenderable> renderables, Shape clip) {
        Shape oldClip = g.getClip();
        g.setClip(clip);
        renderables.forEach(r -> r.render(g));
        g.setClip(oldClip);
    }

    public void render(Graphics2D g, IRenderable renderable) {
        if (renderable == null) {
            return;
        }
        renderable.render(g);
    }

    public void renderEntities(Graphics2D g, Collection<? extends IEntity> entities) {
        this.renderEntities(g, entities, true);
    }

    public void renderEntities(Graphics2D g, Collection<? extends IEntity> entities, boolean sort) {
        List entitiesToRender = entities.stream().filter(x -> Game.getCamera().getViewPort().intersects(x.getBoundingBox())).collect(Collectors.toList());
        if (sort) {
            try {
                Collections.sort(entitiesToRender, this.entityComparator);
            }
            catch (IllegalArgumentException e) {
                for (IEntity iEntity : entities) {
                    this.renderEntity(g, iEntity);
                }
                return;
            }
        }
        for (IEntity entity : entitiesToRender) {
            this.renderEntity(g, entity);
        }
    }

    public void renderEntities(Graphics2D g, Collection<? extends IEntity> entities, boolean sort, Shape clip) {
        Shape oldClip = g.getClip();
        if (clip != null) {
            g.setClip(clip);
        }
        this.renderEntities(g, entities, sort);
        g.setClip(oldClip);
    }

    public void renderEntities(Graphics2D g, Collection<? extends IEntity> entities, Shape clip) {
        this.renderEntities(g, entities, true, clip);
    }

    public void renderEntity(Graphics2D g, IEntity entity) {
        IEntityAnimationController animationController;
        if (entity == null) {
            return;
        }
        if (entity.getRenderType() == RenderType.NONE || !this.canRender(entity)) {
            return;
        }
        RenderEvent<IEntity> renderEvent = new RenderEvent<IEntity>(g, entity);
        if (!this.entityRenderingConsumer.isEmpty()) {
            for (Consumer<RenderEvent<IEntity>> consumer : this.entityRenderingConsumer) {
                consumer.accept(renderEvent);
            }
        }
        if ((animationController = entity.getAnimationController()) != null) {
            BufferedImage img = animationController.getCurrentSprite();
            if (img == null) {
                return;
            }
            if (animationController instanceof IEntityAnimationController && animationController.isAutoScaling()) {
                double ratioX = entity.getWidth() / (float)img.getWidth();
                double ratioY = entity.getHeight() / (float)img.getHeight();
                ImageRenderer.renderScaled(g, (Image)img, Game.getCamera().getViewPortLocation(entity.getLocation()), ratioX, ratioY);
            } else {
                float deltaX = (entity.getWidth() - (float)img.getWidth()) / 2.0f;
                float deltaY = (entity.getHeight() - (float)img.getHeight()) / 2.0f;
                ImageRenderer.renderTransformed(g, img, Game.getCamera().getViewPortLocation(entity.getX() + (double)deltaX, entity.getY() + (double)deltaY), animationController.getAffineTransform());
            }
        }
        if (entity instanceof IRenderable) {
            ((IRenderable)((Object)entity)).render(g);
        }
        if (!this.entityRenderedConsumer.isEmpty()) {
            for (Consumer<RenderEvent<IEntity>> consumer : this.entityRenderedConsumer) {
                consumer.accept(renderEvent);
            }
        }
    }

    public void render(Graphics2D g, IMap map, RenderType ... renderTypes) {
        if (map == null) {
            return;
        }
        this.mapRenderer.get((Object)map.getOrientation()).render(g, map, Game.getCamera().getViewPort(), renderTypes);
    }

    public void setBaseRenderScale(float scale) {
        this.baseRenderScale = scale;
    }
}

