/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IInitializable;
import de.gurkenlabs.litiengine.graphics.ImageFormat;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.gui.screens.Screen;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import de.gurkenlabs.litiengine.util.MathUtilities;
import de.gurkenlabs.litiengine.util.io.ImageSerializer;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferStrategy;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class RenderComponent
extends Canvas
implements IInitializable {
    public static final Color DEFAULT_BACKGROUND_COLOR = Color.BLACK;
    private static final int DEBUG_MOUSE_SIZE = 5;
    private final transient List<Consumer<Integer>> fpsChangedConsumer;
    private final transient List<Consumer<Graphics2D>> renderedConsumer;
    private transient BufferStrategy currentBufferStrategy;
    private float currentAlpha;
    private transient Image cursorImage;
    private transient AffineTransform cursorTransform;
    private int cursorOffsetX;
    private int cursorOffsetY;
    private long fadeInStart;
    private int fadeInTime;
    private long fadeOutStart;
    private int fadeOutTime;
    private int frameCount = 0;
    private long lastFpsTime = System.currentTimeMillis();
    private boolean takeScreenShot;

    public RenderComponent(Dimension size) {
        this.renderedConsumer = new CopyOnWriteArrayList<Consumer<Graphics2D>>();
        this.fpsChangedConsumer = new CopyOnWriteArrayList<Consumer<Integer>>();
        this.setBackground(DEFAULT_BACKGROUND_COLOR);
        BufferedImage cursorImg = ImageProcessing.getCompatibleImage(16, 16);
        Cursor blankCursor = Toolkit.getDefaultToolkit().createCustomCursor(cursorImg, new Point(0, 0), "blank cursor");
        this.setCursor(blankCursor);
        this.setSize(size);
        this.setPreferredSize(size);
    }

    public void fadeIn(int ms) {
        this.fadeOutStart = -1L;
        this.fadeOutTime = -1;
        this.fadeInStart = Game.getLoop().getTicks();
        this.fadeInTime = ms;
    }

    public void fadeOut(int ms) {
        this.fadeInStart = -1L;
        this.fadeInTime = -1;
        this.fadeOutStart = Game.getLoop().getTicks();
        this.fadeOutTime = ms;
    }

    public Image getCursorImage() {
        return this.cursorImage;
    }

    public AffineTransform getCursorTransform() {
        return this.cursorTransform;
    }

    public int getCursorOffsetX() {
        return this.cursorOffsetX;
    }

    public int getCursorOffsetY() {
        return this.cursorOffsetY;
    }

    @Override
    public void init() {
        this.createBufferStrategy(2);
        this.currentBufferStrategy = this.getBufferStrategy();
        this.currentAlpha = 1.1f;
    }

    public void onFpsChanged(Consumer<Integer> fpsConsumer) {
        if (this.fpsChangedConsumer.contains(fpsConsumer)) {
            return;
        }
        this.fpsChangedConsumer.add(fpsConsumer);
    }

    public void onRendered(Consumer<Graphics2D> renderedConsumer) {
        if (!this.renderedConsumer.contains(renderedConsumer)) {
            this.renderedConsumer.add(renderedConsumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() {
        long currentMillis = System.currentTimeMillis();
        this.handleFade();
        Graphics2D g = null;
        do {
            try {
                g = (Graphics2D)this.currentBufferStrategy.getDrawGraphics();
                g.setColor(this.getBackground());
                Rectangle bounds = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                g.setClip(bounds);
                g.fill(bounds);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, Game.getConfiguration().graphics().colorInterpolation() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, Game.getConfiguration().graphics().colorInterpolation() ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                Screen currentScreen = Game.getScreenManager().getCurrentScreen();
                if (currentScreen != null) {
                    currentScreen.render(g);
                }
                Point locationOnScreen = this.getLocationOnScreen();
                Rectangle rect = new Rectangle(locationOnScreen.x, locationOnScreen.y, this.getWidth(), this.getHeight());
                PointerInfo pointerInfo = MouseInfo.getPointerInfo();
                if (this.cursorImage != null && (Input.mouse().isGrabMouse() || pointerInfo != null && rect.contains(pointerInfo.getLocation()))) {
                    Point2D.Double locationWithOffset = new Point2D.Double(Input.mouse().getLocation().getX() - (double)this.getCursorOffsetX(), Input.mouse().getLocation().getY() - (double)this.getCursorOffsetY());
                    ImageRenderer.renderTransformed(g, this.cursorImage, locationWithOffset, this.getCursorTransform());
                }
                if (Game.getConfiguration().debug().isRenderDebugMouse()) {
                    g.setColor(Color.RED);
                    g.draw(new Line2D.Double(Input.mouse().getLocation().getX(), Input.mouse().getLocation().getY() - 5.0, Input.mouse().getLocation().getX(), Input.mouse().getLocation().getY() + 5.0));
                    g.draw(new Line2D.Double(Input.mouse().getLocation().getX() - 5.0, Input.mouse().getLocation().getY(), Input.mouse().getLocation().getX() + 5.0, Input.mouse().getLocation().getY()));
                }
                for (Consumer<Graphics2D> consumer2 : this.renderedConsumer) {
                    consumer2.accept(g);
                }
                if (this.currentAlpha != -1.0f) {
                    int visibleAlpha = MathUtilities.clamp(Math.round(255.0f * (1.0f - this.currentAlpha)), 0, 255);
                    g.setColor(new Color(this.getBackground().getRed(), this.getBackground().getGreen(), this.getBackground().getBlue(), visibleAlpha));
                    g.fill(bounds);
                }
                if (this.takeScreenShot && currentScreen != null) {
                    BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 1);
                    Graphics2D imgGraphics = img.createGraphics();
                    currentScreen.render(imgGraphics);
                    imgGraphics.dispose();
                    this.saveScreenShot(img);
                }
            }
            finally {
                if (g != null) {
                    g.dispose();
                }
            }
            this.currentBufferStrategy.show();
        } while (this.currentBufferStrategy.contentsLost());
        Toolkit.getDefaultToolkit().sync();
        ++this.frameCount;
        if (currentMillis - this.lastFpsTime >= 1000L) {
            this.lastFpsTime = currentMillis;
            this.fpsChangedConsumer.forEach(consumer -> consumer.accept(this.frameCount));
            this.frameCount = 0;
        }
    }

    public void setCursor(Image image) {
        this.cursorImage = image;
        if (this.cursorImage != null) {
            this.setCursorOffsetX(-(this.cursorImage.getWidth(null) / 2));
            this.setCursorOffsetY(-(this.cursorImage.getHeight(null) / 2));
        } else {
            this.setCursorOffsetX(0);
            this.setCursorOffsetY(0);
        }
    }

    public void setCursor(Image image, int offsetX, int offsetY) {
        this.setCursor(image);
        this.setCursorOffset(offsetX, offsetY);
    }

    public void setCursorOffset(int x, int y) {
        this.setCursorOffsetX(x);
        this.setCursorOffsetY(y);
    }

    public void setCursorOffsetX(int cursorOffsetX) {
        this.cursorOffsetX = cursorOffsetX;
    }

    public void setCursorOffsetY(int cursorOffsetY) {
        this.cursorOffsetY = cursorOffsetY;
    }

    public void setCursorTransform(AffineTransform transform) {
        this.cursorTransform = transform;
    }

    public void takeScreenshot() {
        this.takeScreenShot = true;
    }

    private void handleFade() {
        if (this.fadeOutStart != -1L) {
            long timePassed = Game.getLoop().getDeltaTime(this.fadeOutStart);
            this.currentAlpha = MathUtilities.clamp(1.0f - (float)timePassed / (float)this.fadeOutTime, 0.0f, 1.0f);
            if (this.currentAlpha == 0.0f) {
                this.fadeOutStart = -1L;
                this.fadeOutTime = -1;
            }
            return;
        }
        if (this.fadeInStart != -1L) {
            long timePassed = Game.getLoop().getDeltaTime(this.fadeInStart);
            this.currentAlpha = MathUtilities.clamp((float)timePassed / (float)this.fadeInTime, 0.0f, 1.0f);
            if (this.currentAlpha == 1.0f) {
                this.fadeInStart = -1L;
                this.fadeInTime = -1;
                this.currentAlpha = -1.0f;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveScreenShot(BufferedImage img) {
        try {
            String timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date());
            File folder = new File("./screenshots/");
            if (!folder.exists()) {
                folder.mkdirs();
            }
            ImageSerializer.saveImage(new File("./screenshots/" + timeStamp + ImageFormat.PNG.toExtension()).toString(), img);
        }
        finally {
            this.takeScreenShot = false;
        }
    }
}

