/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public final class ImageRenderer {
    private ImageRenderer() {
    }

    public static void render(Graphics2D g, Image image, double x, double y) {
        if (image == null) {
            return;
        }
        AffineTransform t = AffineTransform.getTranslateInstance(x, y);
        g.drawImage(image, t, null);
    }

    public static void render(Graphics2D g, Image image, Point2D renderLocation) {
        ImageRenderer.render(g, image, renderLocation.getX(), renderLocation.getY());
    }

    public static void renderRotated(Graphics2D g, Image image, double x, double y, double angle) {
        if (image == null) {
            return;
        }
        if (angle == 0.0 || angle % 360.0 == 0.0) {
            ImageRenderer.render(g, image, x, y);
            return;
        }
        AffineTransform t = new AffineTransform();
        t.translate(x, y);
        t.rotate(Math.toRadians(angle), (double)image.getWidth(null) * 0.5, (double)image.getHeight(null) * 0.5);
        g.drawImage(image, t, null);
    }

    public static void renderRotated(Graphics2D g, Image image, Point2D renderLocation, double angle) {
        ImageRenderer.renderRotated(g, image, renderLocation.getX(), renderLocation.getY(), angle);
    }

    public static void renderScaled(Graphics2D g, Image image, double x, double y, double scale) {
        ImageRenderer.renderScaled(g, image, x, y, scale, scale);
    }

    public static void renderScaled(Graphics2D g, Image image, Point2D location, double scale) {
        ImageRenderer.renderScaled(g, image, location.getX(), location.getY(), scale, scale);
    }

    public static void renderScaled(Graphics2D g, Image image, Point2D location, double scaleX, double scaleY) {
        ImageRenderer.renderScaled(g, image, location.getX(), location.getY(), scaleX, scaleY);
    }

    public static void renderScaled(Graphics2D g, Image image, double x, double y, double scaleX, double scaleY) {
        if (image == null) {
            return;
        }
        if (scaleX == 1.0 && scaleY == 1.0) {
            ImageRenderer.render(g, image, x, y);
            return;
        }
        AffineTransform t = new AffineTransform();
        t.translate(x, y);
        t.scale(scaleX, scaleY);
        g.drawImage(image, t, null);
    }

    public static void renderTransformed(Graphics2D g, Image image, Point2D renderLocation, AffineTransform transform) {
        ImageRenderer.renderTransformed(g, image, renderLocation.getX(), renderLocation.getY(), transform);
    }

    public static void renderTransformed(Graphics2D g, Image image, double x, double y, AffineTransform transform) {
        if (transform == null) {
            ImageRenderer.render(g, image, x, y);
            return;
        }
        AffineTransform t = new AffineTransform();
        t.translate(x, y);
        t.concatenate(transform);
        g.drawImage(image, t, null);
    }

    public static void renderTransformed(Graphics2D g, Image image, AffineTransform transform) {
        if (transform == null) {
            return;
        }
        g.drawImage(image, transform, null);
    }
}

