/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.graphics.Camera;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.geom.Point2D;

public class FreeFlightCamera
extends Camera
implements IUpdateable {
    private static final int SCROLL_PIXELS_PER_SECOND = 400;
    private static final int SCROLL_PADDING = 20;
    private static final int SCROLL_BORDER = 100;
    private Point2D location;

    public FreeFlightCamera(Point2D location) {
        this.location = location;
        Game.getLoop().attach(this);
    }

    public Point2D getLocation() {
        return this.location;
    }

    public void setLocation(Point2D location) {
        this.location = location;
    }

    @Override
    public void update() {
        this.handleFreeFlightCamera();
    }

    @Override
    public void updateFocus() {
        this.setFocus(this.location);
        super.updateFocus();
    }

    private void handleFreeFlightCamera() {
        Point2D mouseLocation = Input.mouse().getLocation();
        double scrollSpeed = 400.0 / (double)Game.getLoop().getUpdateRate() * (double)Game.getConfiguration().input().getMouseSensitivity();
        double x = this.getLocation().getX();
        double y = this.getLocation().getY();
        if (Math.abs(mouseLocation.getX()) < 20.0) {
            x -= scrollSpeed;
        } else if (Math.abs(Game.getScreenManager().getResolution().getWidth() - mouseLocation.getX()) < 20.0) {
            x += scrollSpeed;
        }
        if (Math.abs(mouseLocation.getY()) < 20.0) {
            y -= scrollSpeed;
        } else if (Math.abs(Game.getScreenManager().getResolution().getHeight() - mouseLocation.getY()) < 20.0) {
            y += scrollSpeed;
        }
        if (Game.getEnvironment() != null && Game.getEnvironment().getMap() != null) {
            if (x < -100.0 || x > Game.getEnvironment().getMap().getSizeInPixels().getWidth() + 100.0) {
                x = this.getLocation().getX();
            }
            if (y < -100.0 || y > Game.getEnvironment().getMap().getSizeInPixels().getHeight() + 100.0) {
                y = this.getLocation().getY();
            }
        }
        this.setLocation(new Point2D.Double(x, y));
    }
}

