/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.graphics.MapDebugArgs;
import de.gurkenlabs.litiengine.graphics.TextRenderer;
import de.gurkenlabs.litiengine.input.Input;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class DebugRenderer {
    private static List<Consumer<MapDebugArgs>> mapDebugConsumer = new CopyOnWriteArrayList<Consumer<MapDebugArgs>>();

    private DebugRenderer() {
    }

    public static void onMapDebugRendered(Consumer<MapDebugArgs> cons) {
        mapDebugConsumer.add(cons);
    }

    public static void renderEntityDebugInfo(Graphics2D g, IEntity entity) {
        if (!Game.getConfiguration().debug().isDebugEnabled()) {
            return;
        }
        if (Game.getConfiguration().debug().renderEntityNames()) {
            DebugRenderer.drawMapId(g, entity);
        }
        if (Game.getConfiguration().debug().renderHitBoxes() && entity instanceof ICombatEntity) {
            g.setColor(Color.RED);
            Game.getRenderEngine().renderOutline(g, ((ICombatEntity)entity).getHitBox());
        }
        if (Game.getConfiguration().debug().renderBoundingBoxes()) {
            g.setColor(Color.RED);
            Game.getRenderEngine().renderOutline(g, entity.getBoundingBox());
        }
        if (Game.getConfiguration().debug().renderCollisionBoxes() && entity instanceof ICollisionEntity) {
            ICollisionEntity collisionEntity = (ICollisionEntity)entity;
            g.setColor(collisionEntity.hasCollision() ? Color.RED : Color.ORANGE);
            Game.getRenderEngine().renderOutline(g, collisionEntity.getCollisionBox());
        }
    }

    public static void renderMapDebugInfo(Graphics2D g, IMap map) {
        if (Game.getConfiguration().debug().renderCollisionBoxes()) {
            BasicStroke shapeStroke = new BasicStroke(1.0f / Game.getCamera().getRenderScale());
            for (Rectangle2D rectangle2D : Game.getPhysicsEngine().getStaticCollisionBoxes()) {
                g.setColor(Color.RED);
                Game.getRenderEngine().renderOutline(g, rectangle2D, shapeStroke);
            }
        }
        if (Game.getConfiguration().debug().showTilesMetric()) {
            DebugRenderer.drawTileBoundingBox(g, map, Input.mouse().getMapLocation());
        }
        MapDebugArgs args = new MapDebugArgs(map, g);
        for (Consumer consumer : mapDebugConsumer) {
            consumer.accept(args);
        }
    }

    private static void drawMapId(Graphics2D g, IEntity entity) {
        g.setColor(Color.RED);
        g.setFont(g.getFont().deriveFont(0, 4.0f));
        int x = (int)Game.getCamera().getViewPortDimensionCenter(entity).getX() + 10;
        int y = (int)Game.getCamera().getViewPortDimensionCenter(entity).getY();
        TextRenderer.render(g, Integer.toString(entity.getMapId()), x, y);
        String locationString = "[x:" + new DecimalFormat("##.##").format(entity.getLocation().getX()) + ";y:" + new DecimalFormat("##.##").format(entity.getLocation().getY()) + "]";
        TextRenderer.render(g, locationString, x, (double)y + 5.0);
    }

    private static void drawTileBoundingBox(Graphics2D g, IMap map, Point2D location) {
        Rectangle2D playerTile = MapUtilities.getTileBoundingBox(map, location);
        g.setColor(Color.CYAN);
        Game.getRenderEngine().renderOutline(g, playerTile);
        Point tileLocation = MapUtilities.getTile(map, location);
        String locationText = tileLocation.x + ", " + tileLocation.y;
        g.setFont(g.getFont().deriveFont(3.0f));
        FontMetrics fm = g.getFontMetrics();
        Point2D relative = Game.getCamera().getViewPortLocation(playerTile.getX(), playerTile.getY());
        TextRenderer.render(g, locationText, (float)(relative.getX() + playerTile.getWidth() + 3.0), (float)(relative.getY() + (double)fm.getHeight()));
        List<ITile> tiles = MapUtilities.getTilesByPixelLocation(map, location);
        StringBuilder sb = new StringBuilder();
        for (ITile tile : tiles) {
            sb.append("[gid: " + tile.getGridId() + "] ");
        }
        TextRenderer.render(g, sb.toString(), (float)(relative.getX() + playerTile.getWidth() + 3.0), (float)(relative.getY() + (double)(fm.getHeight() * 2) + 2.0));
    }
}

