/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import de.gurkenlabs.litiengine.util.MathUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public abstract class ColorLayer
implements IRenderable {
    private final IEnvironment environment;
    private final Image[][] tiles;
    private int alpha;
    private Color color;

    protected ColorLayer(IEnvironment env, Color color, int alpha) {
        this.environment = env;
        this.color = color;
        this.alpha = alpha;
        this.tiles = new Image[env.getMap().getSizeInTiles().width][env.getMap().getSizeInTiles().height];
        this.updateSection(this.environment.getMap().getBounds());
    }

    @Override
    public void render(Graphics2D g) {
        Rectangle2D viewport = Game.getCamera().getViewPort();
        IMap map = this.getEnvironment().getMap();
        Point startTile = MapUtilities.getTile(map, new Point2D.Double(viewport.getX(), viewport.getY()));
        Point endTile = MapUtilities.getTile(map, new Point2D.Double(viewport.getMaxX(), viewport.getMaxY()));
        int startX = MathUtilities.clamp(startTile.x, 0, this.tiles.length - 1);
        int endX = MathUtilities.clamp(endTile.x, 0, this.tiles.length - 1);
        int startY = MathUtilities.clamp(startTile.y, 0, this.tiles[0].length - 1);
        int endY = MathUtilities.clamp(endTile.y, 0, this.tiles[0].length - 1);
        Point2D origin = Game.getCamera().getViewPortLocation(0.0, 0.0);
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                ImageRenderer.render(g, this.tiles[x][y], origin.getX() + (double)(x * map.getTileSize().width), origin.getY() + (double)(y * map.getTileSize().height));
            }
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public Color getColor() {
        return this.color;
    }

    public Color getColorWithAlpha() {
        return new Color(this.getColor().getRed(), this.getColor().getGreen(), this.getColor().getBlue(), this.getAlpha());
    }

    public void setAlpha(int ambientAlpha) {
        this.alpha = MathUtilities.clamp(ambientAlpha, 0, 255);
        this.updateSection(this.environment.getMap().getBounds());
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateSection(this.environment.getMap().getBounds());
    }

    public void updateSection(Rectangle2D section) {
        if (this.getColor() == null) {
            return;
        }
        IMap map = this.getEnvironment().getMap();
        Rectangle2D tileSection = MapUtilities.getTileBoundingBox(map, section);
        BufferedImage img = ImageProcessing.getCompatibleImage((int)tileSection.getWidth(), (int)tileSection.getHeight());
        Graphics2D g = img.createGraphics();
        this.renderSection(g, tileSection);
        g.dispose();
        this.setTiles(img, tileSection);
    }

    private void setTiles(BufferedImage img, Rectangle2D section) {
        IMap map = this.getEnvironment().getMap();
        Point startTile = MapUtilities.getTile(map, new Point2D.Double(section.getX(), section.getY()));
        Point endTile = MapUtilities.getTile(map, new Point2D.Double(section.getMaxX(), section.getMaxY()));
        int startX = MathUtilities.clamp(startTile.x, 0, Math.min(startTile.x + (endTile.x - startTile.x), this.tiles.length) - 1);
        int startY = MathUtilities.clamp(startTile.y, 0, Math.min(startTile.y + (endTile.y - startTile.y), this.tiles[0].length) - 1);
        int endX = MathUtilities.clamp(endTile.x, 0, Math.min(startTile.x + (endTile.x - startTile.x), this.tiles.length) - 1);
        int endY = MathUtilities.clamp(endTile.y, 0, Math.min(startTile.y + (endTile.y - startTile.y), this.tiles[0].length) - 1);
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                int subX = (x - startX) * map.getTileSize().width;
                int subY = (y - startY) * map.getTileSize().height;
                BufferedImage smallImage = img.getSubimage(subX, subY, map.getTileSize().width, map.getTileSize().height);
                this.tiles[x][y] = smallImage;
            }
        }
    }

    protected abstract void renderSection(Graphics2D var1, Rectangle2D var2);

    protected IEnvironment getEnvironment() {
        return this.environment;
    }
}

