/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.graphics;

import de.gurkenlabs.litiengine.entities.LightSource;
import de.gurkenlabs.litiengine.entities.StaticShadow;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.graphics.ColorLayer;
import de.gurkenlabs.litiengine.util.MathUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import de.gurkenlabs.litiengine.util.geom.Vector2D;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class AmbientLight
extends ColorLayer {
    public AmbientLight(IEnvironment env, Color ambientColor, int ambientAlpha) {
        super(env, ambientColor, ambientAlpha);
    }

    @Override
    protected void renderSection(Graphics2D g, Rectangle2D section) {
        Color colorWithAlpha = this.getColorWithAlpha();
        double width = section.getWidth();
        double height = section.getHeight();
        double mapWidth = this.getEnvironment().getMap().getSizeInPixels().width;
        double mapHeight = this.getEnvironment().getMap().getSizeInPixels().height;
        double longerDimension = mapWidth;
        if (mapWidth < mapHeight) {
            longerDimension = mapHeight;
        }
        Area darkArea = new Area(new Rectangle2D.Double(0.0, 0.0, width, height));
        for (LightSource light : this.getEnvironment().getLightSources()) {
            if (!light.getBoundingBox().intersects(section) || !light.isActive()) continue;
            this.renderLightSource(g, light, longerDimension, section);
        }
        g.setColor(colorWithAlpha);
        g.setComposite(AlphaComposite.getInstance(7, 1.0f));
        g.fill(darkArea);
        for (LightSource light : this.getEnvironment().getLightSources()) {
            if (!light.getBoundingBox().intersects(section) || !light.isActive() || light.getIntensity() <= 0) continue;
            float intensity = MathUtilities.clamp((float)light.getIntensity() / 255.0f, 0.0f, 1.0f);
            g.setComposite(AlphaComposite.getInstance(3, intensity));
            this.renderLightSource(g, light, longerDimension, section);
        }
    }

    private void renderLightSource(Graphics2D g, LightSource light, double longerDimension, Rectangle2D section) {
        Shape fillShape;
        Point2D lightCenter = light.getCenter();
        Point2D.Double lightFocus = new Point2D.Double(lightCenter.getX() + light.getBoundingBox().getWidth() * light.getFocusOffsetX(), lightCenter.getY() + light.getBoundingBox().getHeight() * light.getFocusOffsetY());
        Area lightArea = null;
        if (light.getLightShapeType().equals("rectangle")) {
            g.setColor(new Color(light.getColor().getRed(), light.getColor().getGreen(), light.getColor().getBlue(), light.getColor().getAlpha()));
            Rectangle2D.Double fillShape2 = new Rectangle2D.Double(light.getBoundingBox().getX() - section.getX(), light.getBoundingBox().getY() - section.getY(), light.getBoundingBox().getWidth(), light.getBoundingBox().getHeight());
            g.fill(fillShape2);
            return;
        }
        for (StaticShadow col : this.getEnvironment().getStaticShadows()) {
            Line2D[] bounds;
            if (!light.getBoundingBox().intersects(col.getBoundingBox())) continue;
            if (lightArea == null) {
                lightArea = new Area(light.getLightShape());
            }
            if (!lightArea.intersects(col.getBoundingBox())) continue;
            Area boxInLight = new Area(col.getBoundingBox());
            for (Line2D line : bounds = GeometricUtilities.getLines(col.getBoundingBox())) {
                Vector2D lineVector = new Vector2D(line.getP1(), line.getP2());
                Vector2D lightVector = new Vector2D(lightFocus, line.getP1());
                if (light.getCenter().getY() < line.getY1() && light.getCenter().getY() < line.getY2() && col.getBoundingBox().contains(light.getCenter()) || lineVector.normalVector().dotProduct(lightVector) >= 0.0) continue;
                Path2D.Double shadowParallelogram = new Path2D.Double();
                Point2D shadowPoint1 = GeometricUtilities.project((Point2D)lightFocus, line.getP1(), longerDimension);
                Point2D shadowPoint2 = GeometricUtilities.project((Point2D)lightFocus, line.getP2(), longerDimension);
                ((Path2D)shadowParallelogram).moveTo(line.getP1().getX(), line.getP1().getY());
                ((Path2D)shadowParallelogram).lineTo(shadowPoint1.getX(), shadowPoint1.getY());
                ((Path2D)shadowParallelogram).lineTo(shadowPoint2.getX(), shadowPoint2.getY());
                ((Path2D)shadowParallelogram).lineTo(line.getP2().getX(), line.getP2().getY());
                shadowParallelogram.closePath();
                Area shadowArea = new Area(shadowParallelogram);
                if (light.getCenter().getY() < col.getBoundingBox().getMaxY() && !col.getBoundingBox().contains(light.getCenter())) {
                    shadowArea.add(boxInLight);
                }
                shadowArea.intersect(lightArea);
                lightArea.subtract(shadowArea);
            }
        }
        Paint oldPaint = g.getPaint();
        Shape lightShape = light.getLightShape();
        double radius = lightShape.getBounds2D().getWidth() > lightShape.getBounds2D().getHeight() ? lightShape.getBounds2D().getWidth() : lightShape.getBounds2D().getHeight();
        Color[] transColors = new Color[]{light.getColor(), new Color(light.getColor().getRed(), light.getColor().getGreen(), light.getColor().getBlue(), 0)};
        Point2D.Double center = new Point2D.Double(lightShape.getBounds2D().getCenterX() - section.getX(), lightShape.getBounds2D().getCenterY() - section.getY());
        Point2D.Double focus = new Point2D.Double(((Point2D)center).getX() + lightShape.getBounds2D().getWidth() * light.getFocusOffsetX(), ((Point2D)center).getY() + lightShape.getBounds2D().getHeight() * light.getFocusOffsetY());
        RadialGradientPaint paint = new RadialGradientPaint(center, (float)(radius / 2.0), focus, new float[]{0.0f, 1.0f}, transColors, MultipleGradientPaint.CycleMethod.NO_CYCLE);
        g.setPaint(paint);
        if (lightArea != null) {
            lightArea.transform(AffineTransform.getTranslateInstance(-section.getX(), -section.getY()));
            fillShape = lightArea;
        } else {
            fillShape = new Rectangle2D.Double(light.getBoundingBox().getX() - section.getX(), light.getBoundingBox().getY() - section.getY(), light.getBoundingBox().getWidth(), light.getBoundingBox().getHeight());
        }
        g.fill(fillShape);
        g.setPaint(oldPaint);
    }
}

