/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.ITerrain;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimation;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Animation;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Property;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import java.awt.Point;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="tile")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Tile
extends CustomPropertyProvider
implements ITile,
Serializable {
    protected static final long FLIPPED_HORIZONTALLY_FLAG = Integer.MIN_VALUE;
    protected static final long FLIPPED_VERTICALLY_FLAG = -3221225472L;
    protected static final long FLIPPED_DIAGONALLY_FLAG = -3758096384L;
    protected static final long FLIPPED_HORIZONTALLY_FLAG_CSV = 0x80000000L;
    protected static final long FLIPPED_VERTICALLY_FLAG_CSV = 0x40000000L;
    protected static final long FLIPPED_DIAGONALLY_FLAG_CSV = 0x20000000L;
    private static final long serialVersionUID = -7597673646108642906L;
    @XmlAttribute
    private Integer gid;
    @XmlAttribute
    private Integer id;
    @XmlAttribute
    private String terrain;
    @XmlElement(required=false)
    private Animation animation;
    private transient Point tileCoordinate;
    private transient ITerrain[] terrains;
    private transient ITile customPropertySource;
    private transient boolean flippedDiagonally;
    private transient boolean flippedHorizontally;
    private transient boolean flippedVertically;
    private transient boolean flipped;

    public Tile() {
    }

    public Tile(int gid) {
        this.gid = gid;
    }

    public Tile(long gidBitmask, boolean csv) {
        long tileId = gidBitmask;
        if (csv) {
            tileId &= 0xFFFFFFFF1FFFFFFFL;
            this.flippedDiagonally = (gidBitmask & 0x20000000L) == 0x20000000L;
            this.flippedHorizontally = (gidBitmask & 0x80000000L) == 0x80000000L;
            this.flippedVertically = (gidBitmask & 0x40000000L) == 0x40000000L;
        } else {
            tileId &= 0x1FFFFFFFL;
            this.flippedDiagonally = (gidBitmask & 0xFFFFFFFF20000000L) == -3758096384L;
            this.flippedHorizontally = (gidBitmask & Integer.MIN_VALUE) == Integer.MIN_VALUE;
            this.flippedVertically = (gidBitmask & 0xFFFFFFFF40000000L) == -3221225472L;
        }
        this.flipped = this.isFlippedDiagonally() || this.isFlippedHorizontally() || this.isFlippedVertically();
        this.gid = (int)tileId;
    }

    @Override
    public boolean hasCustomProperty(String name) {
        return this.customPropertySource == null ? super.hasCustomProperty(name) : this.customPropertySource.hasCustomProperty(name);
    }

    @Override
    public List<Property> getCustomProperties() {
        return this.customPropertySource == null ? super.getCustomProperties() : this.customPropertySource.getCustomProperties();
    }

    @Override
    public void setCustomProperties(List<Property> props) {
        if (this.customPropertySource == null) {
            super.setCustomProperties(props);
        } else {
            this.customPropertySource.setCustomProperties(props);
        }
    }

    @Override
    public String getCustomProperty(String name, String defaultValue) {
        return this.customPropertySource == null ? super.getCustomProperty(name, defaultValue) : this.customPropertySource.getCustomProperty(name, defaultValue);
    }

    @Override
    public void setCustomProperty(String name, String value) {
        if (this.customPropertySource == null) {
            super.setCustomProperty(name, value);
        } else {
            this.customPropertySource.setCustomProperty(name, value);
        }
    }

    @Override
    public boolean isFlippedDiagonally() {
        return this.flippedDiagonally;
    }

    @Override
    public boolean isFlippedHorizontally() {
        return this.flippedHorizontally;
    }

    @Override
    public boolean isFlippedVertically() {
        return this.flippedVertically;
    }

    @Override
    public boolean isFlipped() {
        return this.flipped;
    }

    @Override
    public int getGridId() {
        if (this.gid == null) {
            return 0;
        }
        return this.gid;
    }

    @Override
    public Point getTileCoordinate() {
        return this.tileCoordinate;
    }

    public void setTileCoordinate(Point tileCoordinate) {
        this.tileCoordinate = tileCoordinate;
    }

    @Override
    public int getId() {
        if (this.id == null) {
            return 0;
        }
        return this.id;
    }

    @Override
    public ITerrain[] getTerrain() {
        return this.customPropertySource == null ? this.terrains : this.customPropertySource.getTerrain();
    }

    @Override
    public ITileAnimation getAnimation() {
        return this.customPropertySource == null ? this.animation : this.customPropertySource.getAnimation();
    }

    public String toString() {
        return this.getGridId() + " (" + Arrays.toString(this.getTerrainIds()) + ")";
    }

    protected int[] getTerrainIds() {
        int[] terrainIds = new int[]{-1, -1, -1, -1};
        if (this.terrain == null || this.terrain.isEmpty()) {
            return terrainIds;
        }
        int[] ids = ArrayUtilities.getIntegerArray(this.terrain);
        if (ids.length != 4) {
            return terrainIds;
        }
        terrainIds = ids;
        return terrainIds;
    }

    protected void setTerrains(ITerrain[] terrains) {
        this.terrains = terrains;
    }

    protected void setCustomPropertySource(ITile source) {
        this.customPropertySource = source;
    }

    private void afterUnmarshal(Unmarshaller u, Object parent) {
        if (this.gid != null && this.gid == 0) {
            this.gid = null;
        }
        if (this.id != null && this.id == 0) {
            this.id = null;
        }
    }
}

