/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.ILayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.CustomPropertyProvider;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Map;
import de.gurkenlabs.litiengine.graphics.RenderType;
import java.awt.Dimension;
import java.awt.Point;
import java.io.Serializable;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;

public abstract class Layer
extends CustomPropertyProvider
implements ILayer,
Serializable {
    private static final long serialVersionUID = -5136089511774411328L;
    @XmlAttribute
    private String name;
    @XmlAttribute
    private Integer width;
    @XmlAttribute
    private Integer height;
    @XmlAttribute
    private Float opacity;
    @XmlAttribute
    private Integer visible;
    @XmlAttribute
    private Integer offsetx;
    @XmlAttribute
    private Integer offsety;
    private transient Map parentMap;
    private transient RenderType renderType;
    private transient boolean renderTypeLoaded;

    public Layer() {
    }

    public Layer(ILayer layerToBeCopied) {
        super(layerToBeCopied);
        this.setWidth(layerToBeCopied.getWidth());
        this.setHeight(layerToBeCopied.getHeight());
        this.setName(layerToBeCopied.getName());
        this.setOffsetX(layerToBeCopied.getOffsetX());
        this.setOffsetY(layerToBeCopied.getOffsetY());
        this.setOpacity(layerToBeCopied.getOpacity());
        this.setOrder(layerToBeCopied.getOrder());
        this.setVisible(layerToBeCopied.isVisible());
    }

    @Override
    public int getHeight() {
        if (this.height == null) {
            if (this.parentMap == null) {
                return 0;
            }
            return this.parentMap.getSizeInTiles().height;
        }
        return this.height;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public float getOpacity() {
        if (this.opacity == null) {
            return 1.0f;
        }
        return this.opacity.floatValue();
    }

    @Override
    public Point getPosition() {
        return new Point(this.getOffsetX(), this.getOffsetY());
    }

    @Override
    public int getOffsetX() {
        if (this.offsetx == null) {
            return 0;
        }
        return this.offsetx;
    }

    @Override
    public int getOffsetY() {
        if (this.offsety == null) {
            return 0;
        }
        return this.offsety;
    }

    @Override
    public RenderType getRenderType() {
        if (this.renderTypeLoaded) {
            return this.renderType;
        }
        String renderTypeProp = this.getCustomProperty("RENDERTYPE");
        this.renderType = renderTypeProp != null && !renderTypeProp.isEmpty() ? RenderType.valueOf(renderTypeProp) : RenderType.GROUND;
        this.renderTypeLoaded = true;
        return this.renderType;
    }

    @Override
    public Dimension getSizeInTiles() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    @Override
    public int getWidth() {
        if (this.width == null) {
            if (this.parentMap == null) {
                return 0;
            }
            return this.parentMap.getSizeInTiles().width;
        }
        return this.width;
    }

    @Override
    public int getOrder() {
        return this.getCustomPropertyInt("layerOrder", -1);
    }

    @Override
    public boolean isVisible() {
        if (this.visible == null) {
            return true;
        }
        return this.visible > 0;
    }

    @Override
    @XmlTransient
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @XmlTransient
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    @XmlTransient
    public void setHeight(int height) {
        this.height = height;
    }

    @XmlTransient
    public void setOpacity(float opacity) {
        this.opacity = Float.valueOf(opacity);
    }

    @Override
    @XmlTransient
    public void setVisible(boolean visible) {
        this.visible = visible ? 1 : 0;
    }

    @XmlTransient
    public void setOffsetX(int offsetX) {
        this.offsetx = offsetX;
    }

    @XmlTransient
    public void setOffsetY(int offsetY) {
        this.offsety = offsetY;
    }

    private void setOrder(int order) {
        this.setCustomProperty("layerOrder", Integer.toString(order));
    }

    private void afterUnmarshal(Unmarshaller u, Object parent) {
        int order;
        if (parent instanceof Map) {
            this.parentMap = (Map)parent;
        }
        if ((order = this.getCustomPropertyInt("layerOrder", -1)) == -1 && this.parentMap != null) {
            int layerCnt = this.parentMap.getRawImageLayers().size();
            layerCnt += this.parentMap.getRawMapObjectLayers().size();
            this.setOrder(layerCnt += this.parentMap.getRawTileLayers().size());
        }
        if (this.offsetx != null && this.offsetx == 0) {
            this.offsetx = null;
        }
        if (this.offsety != null && this.offsety == 0) {
            this.offsety = null;
        }
        if (this.width != null && this.width == 0) {
            this.width = null;
        }
        if (this.height != null && this.height == 0) {
            this.height = null;
        }
        if (this.opacity != null && this.opacity.floatValue() == 1.0f) {
            this.opacity = null;
        }
        if (this.visible != null && this.visible == 1) {
            this.visible = null;
        }
    }
}

