/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap.xml;

import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimation;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimationFrame;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Frame;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="animation")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Animation
implements ITileAnimation,
Serializable {
    private static final long serialVersionUID = -6359129685451548791L;
    @XmlElement(name="frame")
    private List<Frame> frames;
    private transient List<ITileAnimationFrame> tileAnimationFrames;
    private transient int totalDuration;

    @Override
    public List<ITileAnimationFrame> getFrames() {
        if (this.tileAnimationFrames != null) {
            return this.tileAnimationFrames;
        }
        ArrayList<ITileAnimationFrame> fr = new ArrayList<ITileAnimationFrame>();
        if (this.frames == null) {
            return fr;
        }
        for (ITileAnimationFrame iTileAnimationFrame : this.frames) {
            fr.add(iTileAnimationFrame);
        }
        this.tileAnimationFrames = fr;
        return this.tileAnimationFrames;
    }

    @Override
    public int getTotalDuration() {
        if (this.totalDuration > 0) {
            return this.totalDuration;
        }
        if (this.getFrames().isEmpty()) {
            return 0;
        }
        for (ITileAnimationFrame frame : this.getFrames()) {
            if (frame == null) continue;
            this.totalDuration += frame.getDuration();
        }
        return this.totalDuration;
    }
}

