/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.environment.tilemap.IImageLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ILayer;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapRenderer;
import de.gurkenlabs.litiengine.environment.tilemap.ITile;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimation;
import de.gurkenlabs.litiengine.environment.tilemap.ITileAnimationFrame;
import de.gurkenlabs.litiengine.environment.tilemap.ITileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.environment.tilemap.MapOrientation;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.graphics.ImageCache;
import de.gurkenlabs.litiengine.graphics.ImageRenderer;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import de.gurkenlabs.litiengine.util.MathUtilities;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class OrthogonalMapRenderer
implements IMapRenderer {
    @Override
    public BufferedImage getImage(IMap map, RenderType ... renderTypes) {
        String cacheKey = OrthogonalMapRenderer.getCacheKey(map) + "_" + renderTypes;
        if (ImageCache.MAPS.containsKey(cacheKey)) {
            return ImageCache.MAPS.get(cacheKey);
        }
        BufferedImage img = ImageProcessing.getCompatibleImage((int)map.getSizeInPixels().getWidth(), (int)map.getSizeInPixels().getHeight());
        Graphics2D g = img.createGraphics();
        for (ITileLayer layer : map.getTileLayers()) {
            if (layer == null || !OrthogonalMapRenderer.shouldBeRendered(layer, renderTypes)) continue;
            ImageRenderer.render(g, this.getLayerImage(layer, map, true), layer.getPosition());
        }
        g.dispose();
        ImageCache.MAPS.put(cacheKey, img);
        return img;
    }

    @Override
    public BufferedImage getImage(IMap map) {
        return this.getImage(map, RenderType.BACKGROUND, RenderType.GROUND, RenderType.SURFACE, RenderType.NORMAL, RenderType.OVERLAY);
    }

    @Override
    public MapOrientation getSupportedOrientation() {
        return MapOrientation.ORTHOGONAL;
    }

    @Override
    public void render(Graphics2D g, IMap map, RenderType ... renderTypes) {
        this.render(g, map, 0.0, 0.0, renderTypes);
    }

    @Override
    public void render(Graphics2D g, IMap map, double offsetX, double offsetY, RenderType ... renderTypes) {
        BufferedImage mapImage = this.getImage(map, renderTypes);
        ImageRenderer.render(g, mapImage, offsetX, offsetY);
    }

    @Override
    public void render(Graphics2D g, IMap map, Rectangle2D viewport, RenderType ... renderTypes) {
        for (ILayer layer : map.getRenderLayers()) {
            if (layer == null || !OrthogonalMapRenderer.shouldBeRendered(layer, renderTypes)) continue;
            if (layer instanceof ITileLayer) {
                this.renderTileLayerImage(g, (ITileLayer)layer, map, viewport);
            }
            if (!(layer instanceof IImageLayer)) continue;
            this.renderImageLayer(g, (IImageLayer)layer, viewport);
        }
    }

    private static boolean shouldBeRendered(ILayer layer, RenderType[] renderTypes) {
        if (renderTypes == null || renderTypes.length == 0) {
            return OrthogonalMapRenderer.isVisible(layer);
        }
        for (RenderType alloc : renderTypes) {
            if (alloc != layer.getRenderType()) continue;
            return OrthogonalMapRenderer.isVisible(layer);
        }
        return false;
    }

    private static boolean isVisible(ILayer layer) {
        return layer.isVisible() && layer.getOpacity() > 0.0f;
    }

    private static String getCacheKey(IMap map) {
        return "map_" + map.getName();
    }

    private static Image getTileImage(IMap map, ITile tile) {
        if (tile == null) {
            return null;
        }
        ITileset tileset = MapUtilities.findTileSet(map, tile);
        if (tileset == null || tileset.getFirstGridId() > tile.getGridId()) {
            return null;
        }
        Spritesheet sprite = tileset.getSpritesheet();
        if (sprite == null) {
            return null;
        }
        int index = tile.getGridId() - tileset.getFirstGridId();
        ITileAnimation animation = MapUtilities.getAnimation(map, index);
        if (animation != null && !animation.getFrames().isEmpty()) {
            long playedMs = Game.getTime().sinceGameStart();
            int totalDuration = animation.getTotalDuration();
            long animationsPlayed = playedMs / (long)totalDuration;
            long deltaTicks = playedMs - animationsPlayed * (long)totalDuration;
            int currentPlayTime = 0;
            for (ITileAnimationFrame frame : animation.getFrames()) {
                if (deltaTicks >= (long)(currentPlayTime += frame.getDuration())) continue;
                index = frame.getTileId();
                break;
            }
        }
        BufferedImage tileImage = sprite.getSprite(index);
        if (tile.isFlipped()) {
            if (tile.isFlippedDiagonally()) {
                tileImage = ImageProcessing.rotate(tileImage, Math.toRadians(90.0));
                tileImage = ImageProcessing.verticalFlip(tileImage);
            }
            if (tile.isFlippedHorizontally()) {
                tileImage = ImageProcessing.horizontalFlip(tileImage);
            }
            if (tile.isFlippedVertically()) {
                tileImage = ImageProcessing.verticalFlip(tileImage);
            }
        }
        return tileImage;
    }

    private synchronized BufferedImage getLayerImage(ITileLayer layer, IMap map, boolean includeAnimationTiles) {
        String cacheKey = OrthogonalMapRenderer.getCacheKey(map) + "_" + layer.getName();
        if (ImageCache.MAPS.containsKey(cacheKey)) {
            return ImageCache.MAPS.get(cacheKey);
        }
        BufferedImage bufferedImage = ImageProcessing.getCompatibleImage(layer.getSizeInTiles().width * map.getTileSize().width, layer.getSizeInTiles().height * map.getTileSize().height);
        Graphics2D imageGraphics = bufferedImage.createGraphics();
        AlphaComposite ac = AlphaComposite.getInstance(3, layer.getOpacity());
        imageGraphics.setComposite(ac);
        layer.getTiles().parallelStream().forEach(tile -> {
            int index = layer.getTiles().indexOf(tile);
            if (tile.getGridId() == 0) {
                return;
            }
            if (!includeAnimationTiles && MapUtilities.hasAnimation(map, tile)) {
                return;
            }
            Image tileTexture = OrthogonalMapRenderer.getTileImage(map, tile);
            int x = index % layer.getSizeInTiles().width * map.getTileSize().width;
            int y = index / layer.getSizeInTiles().width * map.getTileSize().height;
            ImageRenderer.render(imageGraphics, tileTexture, x, y);
        });
        ImageCache.MAPS.put(cacheKey, bufferedImage);
        return bufferedImage;
    }

    private void renderTileLayerImage(Graphics2D g, ITileLayer layer, IMap map, Rectangle2D viewport) {
        Point startTile = MapUtilities.getTile(map, new Point2D.Double(viewport.getX(), viewport.getY()));
        Point endTile = MapUtilities.getTile(map, new Point2D.Double(viewport.getMaxX(), viewport.getMaxY()));
        double viewportOffsetX = -(viewport.getX() - (double)(startTile.x * map.getTileSize().width)) + (double)layer.getPosition().x;
        double viewportOffsetY = -(viewport.getY() - (double)(startTile.y * map.getTileSize().height)) + (double)layer.getPosition().y;
        Composite oldComp = g.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, layer.getOpacity());
        g.setComposite(ac);
        int startX = MathUtilities.clamp(startTile.x, 0, layer.getSizeInTiles().width);
        int endX = MathUtilities.clamp(endTile.x, 0, layer.getSizeInTiles().width);
        int startY = MathUtilities.clamp(startTile.y, 0, layer.getSizeInTiles().height);
        int endY = MathUtilities.clamp(endTile.y, 0, layer.getSizeInTiles().height);
        double offsetX = viewportOffsetX + (double)((startX - startTile.x) * map.getTileSize().width);
        double offsetY = viewportOffsetY + (double)((startY - startTile.y) * map.getTileSize().height);
        for (int x = startX; x <= endX; ++x) {
            for (int y = startY; y <= endY; ++y) {
                ITile tile = layer.getTile(x, y);
                if (tile == null) continue;
                Image tileTexture = OrthogonalMapRenderer.getTileImage(map, tile);
                ImageRenderer.render(g, tileTexture, offsetX + (double)((x - startX) * map.getTileSize().width), offsetY + (double)((y - startY) * map.getTileSize().height));
            }
        }
        g.setComposite(oldComp);
    }

    private void renderImageLayer(Graphics2D g, IImageLayer layer, Rectangle2D viewport) {
        Spritesheet sprite = Spritesheet.find(layer.getImage().getSource());
        if (sprite == null) {
            return;
        }
        Composite oldComp = g.getComposite();
        AlphaComposite ac = AlphaComposite.getInstance(3, layer.getOpacity());
        g.setComposite(ac);
        double viewportOffsetX = -viewport.getX() + (double)layer.getPosition().x;
        double viewportOffsetY = -viewport.getY() + (double)layer.getPosition().y;
        ImageRenderer.render(g, sprite.getImage(), viewportOffsetX, viewportOffsetY);
        g.setComposite(oldComp);
    }
}

