/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment.tilemap;

import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Map;
import de.gurkenlabs.litiengine.environment.tilemap.xml.TileLayer;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Tileset;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import de.gurkenlabs.litiengine.util.io.XmlUtilities;

public final class MapLoader {
    private MapLoader() {
    }

    public static IMap load(String path) {
        Map map = XmlUtilities.readFromFile(Map.class, path);
        if (map == null) {
            return null;
        }
        String basePath = FileUtilities.getParentDirPath(path);
        for (Tileset tilesets : map.getRawTilesets()) {
            tilesets.loadFromSource(basePath);
        }
        for (TileLayer layer : map.getRawTileLayers()) {
            layer.setCustomPropertySources(map);
        }
        String name = FileUtilities.getFileName(path);
        map.setName(name);
        map.setPath(path);
        map.updateTileTerrain();
        return map;
    }
}

