/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.Trigger;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.ICustomPropertyProvider;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import java.util.ArrayList;
import java.util.Collection;

public class TriggerMapObjectLoader
extends MapObjectLoader {
    protected TriggerMapObjectLoader() {
        super(MapObjectType.TRIGGER);
    }

    @Override
    public Collection<IEntity> load(IEnvironment environment, IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.TRIGGER) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + TriggerMapObjectLoader.class);
        }
        String message = mapObject.getCustomProperty("triggermessage");
        Trigger.TriggerActivation act = mapObject.getCustomProperty("triggerActivation") != null ? Trigger.TriggerActivation.valueOf(mapObject.getCustomProperty("triggerActivation")) : Trigger.TriggerActivation.COLLISION;
        boolean oneTime = mapObject.getCustomPropertyBool("triggerOneTime");
        int coolDown = mapObject.getCustomPropertyInt("triggerCooldown");
        Trigger trigger = this.createTrigger(mapObject, act, message, oneTime, coolDown, mapObject);
        TriggerMapObjectLoader.loadDefaultProperties(trigger, mapObject);
        this.loadTargets(mapObject, trigger);
        this.loadActivators(mapObject, trigger);
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        entities.add(trigger);
        return entities;
    }

    protected Trigger createTrigger(IMapObject mapObject, Trigger.TriggerActivation act, String message, boolean oneTime, int coolDown, IMapObject mapObject2) {
        return new Trigger(act, message, oneTime, coolDown, (ICustomPropertyProvider)mapObject);
    }

    protected void loadTargets(IMapObject mapObject, Trigger trigger) {
        String targets = mapObject.getCustomProperty("triggerTarget");
        for (int target : ArrayUtilities.getIntegerArray(targets)) {
            if (target == 0) continue;
            trigger.addTarget(target);
        }
    }

    protected void loadActivators(IMapObject mapObject, Trigger trigger) {
        String activators = mapObject.getCustomProperty("triggerActivators");
        for (int activator : ArrayUtilities.getIntegerArray(activators)) {
            if (activator == 0) continue;
            trigger.addActivator(activator);
        }
    }
}

