/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Direction;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.Spawnpoint;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import java.util.ArrayList;
import java.util.Collection;

public class SpawnpointMapObjectLoader
extends MapObjectLoader {
    protected SpawnpointMapObjectLoader() {
        super(MapObjectType.SPAWNPOINT);
    }

    @Override
    public Collection<IEntity> load(IEnvironment environment, IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.SPAWNPOINT) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + SpawnpointMapObjectLoader.class);
        }
        Direction direction = mapObject.getCustomProperty("spawnDirection") != null ? Direction.valueOf(mapObject.getCustomProperty("spawnDirection")) : Direction.DOWN;
        String spawnType = mapObject.getCustomProperty("spawnType");
        Spawnpoint spawn = this.createSpawnpoint(mapObject, direction, spawnType);
        SpawnpointMapObjectLoader.loadDefaultProperties(spawn, mapObject);
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        entities.add(spawn);
        return entities;
    }

    protected Spawnpoint createSpawnpoint(IMapObject mapObject, Direction direction, String spawnType) {
        return new Spawnpoint(direction, spawnType);
    }
}

