/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.environment.tilemap.xml.DecimalFloatAdapter;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObject;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import java.lang.reflect.Field;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MapObjectSerializer {
    private static final Logger log = Logger.getLogger(MapObjectSerializer.class.getName());

    private MapObjectSerializer() {
    }

    public static MapObject serialize(IEntity entity) {
        MapObject obj = new MapObject();
        obj.setId(entity.getMapId());
        obj.setX((float)entity.getX());
        obj.setY((float)entity.getY());
        obj.setWidth(entity.getWidth());
        obj.setHeight(entity.getHeight());
        obj.setName(entity.getName());
        MapObjectSerializer.serialize(entity.getClass(), entity, obj);
        return obj;
    }

    private static <T extends IEntity> void serialize(Class<?> clz, T entity, MapObject mapObject) {
        for (Field field : clz.getDeclaredFields()) {
            MapObjectSerializer.serialize(field, entity, (IMapObject)mapObject);
        }
        Class<?> parentClass = clz.getSuperclass();
        if (parentClass != null) {
            MapObjectSerializer.serialize(parentClass, entity, mapObject);
        }
    }

    private static void serialize(Field field, Object entity, IMapObject mapObject) {
        TmxProperty property = field.getAnnotation(TmxProperty.class);
        if (property == null) {
            return;
        }
        try {
            Object value;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if ((value = field.get(entity)) == null) {
                return;
            }
            mapObject.setCustomProperty(property.name(), MapObjectSerializer.getPropertyValue(field, value));
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static String getPropertyValue(Field field, Object value) {
        if (field.getType().equals(Float.class) || field.getType().equals(Double.class)) {
            try {
                return new DecimalFloatAdapter().marshal((Float)value);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        } else {
            if (field.getType().equals(Integer.class)) {
                return Integer.toString((Integer)value);
            }
            if (field.getType().equals(Short.TYPE)) {
                return Short.toString((Short)value);
            }
            if (field.getType().equals(Byte.TYPE)) {
                return Byte.toString((Byte)value);
            }
            if (field.getType().equals(Long.TYPE)) {
                return Long.toString((Long)value);
            }
        }
        if (value instanceof List) {
            return ArrayUtilities.getCommaSeparatedString((List)value);
        }
        if (value.getClass().isArray()) {
            if (field.getType().getComponentType() == int[].class || field.getType().getComponentType() == Integer[].class) {
                return ArrayUtilities.getCommaSeparatedString((Integer[])value);
            }
            if (field.getType().getComponentType() == double[].class || field.getType().getComponentType() == Double[].class) {
                return ArrayUtilities.getCommaSeparatedString((Double[])value);
            }
            if (field.getType().getComponentType() == float[].class || field.getType().getComponentType() == Float[].class) {
                return ArrayUtilities.getCommaSeparatedString((Float[])value);
            }
            if (field.getType().getComponentType() == short[].class || field.getType().getComponentType() == Short[].class) {
                return ArrayUtilities.getCommaSeparatedString((Short[])value);
            }
            if (field.getType().getComponentType() == byte[].class || field.getType().getComponentType() == Byte[].class) {
                return ArrayUtilities.getCommaSeparatedString((Byte[])value);
            }
            if (field.getType().getComponentType() == long[].class || field.getType().getComponentType() == Long[].class) {
                return ArrayUtilities.getCommaSeparatedString((Long[])value);
            }
            if (field.getType().getComponentType() == String[].class) {
                return ArrayUtilities.getCommaSeparatedString((String[])value);
            }
            return ArrayUtilities.getCommaSeparatedString((Object[])value);
        }
        return value.toString();
    }
}

