/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.IMapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.util.ReflectionUtilities;
import java.lang.reflect.Field;

public abstract class MapObjectLoader
implements IMapObjectLoader {
    private final String mapObjectType;

    protected MapObjectLoader(String mapObjectType) {
        this.mapObjectType = mapObjectType;
    }

    protected MapObjectLoader(MapObjectType mapObjectType) {
        this.mapObjectType = mapObjectType.name();
    }

    @Override
    public String getMapObjectType() {
        return this.mapObjectType;
    }

    public static void loadDefaultProperties(IEntity entity, IMapObject mapObject) {
        entity.setMapId(mapObject.getId());
        entity.setWidth(mapObject.getWidth());
        entity.setHeight(mapObject.getHeight());
        entity.setName(mapObject.getName());
        entity.setLocation(mapObject.getLocation());
        String tagsString = mapObject.getCustomProperty("tags");
        if (tagsString != null && tagsString.trim().length() > 0) {
            String[] tags;
            for (String rawTag : tags = tagsString.split(",")) {
                String tag = rawTag.trim().replaceAll("[^A-Za-z0-9\\-\\_]", "");
                if (tag == null || tag.isEmpty()) continue;
                entity.addTag(tag);
            }
        }
        MapObjectLoader.loadCustomMapObjectProperties(entity, mapObject);
    }

    private static void loadCustomMapObjectProperties(IEntity entity, IMapObject mapObject) {
        for (Field field : entity.getClass().getDeclaredFields()) {
            TmxProperty property = field.getAnnotation(TmxProperty.class);
            if (property == null) {
                return;
            }
            String value = mapObject.getCustomProperty(property.name());
            if (value == null) continue;
            ReflectionUtilities.setFieldValue(entity.getClass(), entity, property.name(), value);
        }
    }

    public static void loadCollisionProperties(ICollisionEntity entity, IMapObject mapObject) {
        entity.setCollision(mapObject.getCustomPropertyBool("collision", true));
        entity.setCollisionBoxWidth(mapObject.getCustomPropertyFloat("collisionboxWidthFactor", mapObject.getWidth()));
        entity.setCollisionBoxHeight(mapObject.getCustomPropertyFloat("collisionboxHeightFactor", mapObject.getHeight()));
        entity.setCollisionBoxAlign(Align.get(mapObject.getCustomProperty("collisionAlign")));
        entity.setCollisionBoxValign(Valign.get(mapObject.getCustomProperty("collisionValign")));
    }
}

