/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.LightSource;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;

public class LightSourceMapObjectLoader
extends MapObjectLoader {
    protected LightSourceMapObjectLoader() {
        super(MapObjectType.LIGHTSOURCE);
    }

    @Override
    public Collection<IEntity> load(IEnvironment environment, IMapObject mapObject) {
        String lightType;
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.LIGHTSOURCE) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + LightSourceMapObjectLoader.class);
        }
        int alpha = mapObject.getCustomPropertyInt("lightBrightness");
        int intensity = mapObject.getCustomPropertyInt("lightIntensity", 100);
        Color color = mapObject.getCustomPropertyColor("lightColor");
        boolean active = mapObject.getCustomPropertyBool("lightActive", true);
        String lightShape = mapObject.getCustomProperty("lightShape");
        double focusOffsetX = mapObject.getCustomPropertyDouble("lightFocusOffsetX");
        double focusOffsetY = mapObject.getCustomPropertyDouble("lightFocusOffsetY");
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        if (color == null || lightShape == null) {
            return entities;
        }
        switch (lightShape) {
            case "rectangle": {
                lightType = "rectangle";
                break;
            }
            default: {
                lightType = "ellipse";
            }
        }
        LightSource light = this.createLightSource(mapObject, intensity, new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha), lightType, active);
        LightSourceMapObjectLoader.loadDefaultProperties(light, mapObject);
        light.setFocusOffsetX(focusOffsetX);
        light.setFocusOffsetY(focusOffsetY);
        entities.add(light);
        return entities;
    }

    protected LightSource createLightSource(IMapObject mapObject, int intensity, Color color, String lightType, boolean active) {
        return new LightSource(intensity, color, lightType, active);
    }
}

