/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.annotation.EntityInfo;
import de.gurkenlabs.litiengine.configuration.Quality;
import de.gurkenlabs.litiengine.entities.CollisionBox;
import de.gurkenlabs.litiengine.entities.Creature;
import de.gurkenlabs.litiengine.entities.Entity;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.ICombatEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.entities.LightSource;
import de.gurkenlabs.litiengine.entities.MapArea;
import de.gurkenlabs.litiengine.entities.Prop;
import de.gurkenlabs.litiengine.entities.Spawnpoint;
import de.gurkenlabs.litiengine.entities.StaticShadow;
import de.gurkenlabs.litiengine.entities.Trigger;
import de.gurkenlabs.litiengine.environment.CollisionBoxMapObjectLoader;
import de.gurkenlabs.litiengine.environment.CreatureMapObjectLoader;
import de.gurkenlabs.litiengine.environment.CustomMapObjectLoader;
import de.gurkenlabs.litiengine.environment.EmitterMapObjectLoader;
import de.gurkenlabs.litiengine.environment.EnvironmentEntityListener;
import de.gurkenlabs.litiengine.environment.EnvironmentListener;
import de.gurkenlabs.litiengine.environment.EnvironmentRenderListener;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.IMapObjectLoader;
import de.gurkenlabs.litiengine.environment.LightSourceMapObjectLoader;
import de.gurkenlabs.litiengine.environment.MapAreaMapObjectLoader;
import de.gurkenlabs.litiengine.environment.PropMapObjectLoader;
import de.gurkenlabs.litiengine.environment.SpawnpointMapObjectLoader;
import de.gurkenlabs.litiengine.environment.StaticShadowMapObjectLoader;
import de.gurkenlabs.litiengine.environment.TriggerMapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObjectLayer;
import de.gurkenlabs.litiengine.environment.tilemap.MapLoader;
import de.gurkenlabs.litiengine.environment.tilemap.MapUtilities;
import de.gurkenlabs.litiengine.environment.tilemap.xml.Blueprint;
import de.gurkenlabs.litiengine.graphics.AmbientLight;
import de.gurkenlabs.litiengine.graphics.DebugRenderer;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import de.gurkenlabs.litiengine.graphics.RenderComponent;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.StaticShadowLayer;
import de.gurkenlabs.litiengine.graphics.StaticShadowType;
import de.gurkenlabs.litiengine.graphics.emitters.Emitter;
import de.gurkenlabs.litiengine.util.TimeUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class Environment
implements IEnvironment {
    private static final Logger log = Logger.getLogger(Environment.class.getName());
    private static final Map<String, IMapObjectLoader> mapObjectLoaders = new ConcurrentHashMap<String, IMapObjectLoader>();
    private final Map<Integer, ICombatEntity> combatEntities = new ConcurrentHashMap<Integer, ICombatEntity>();
    private final Map<Integer, IMobileEntity> mobileEntities = new ConcurrentHashMap<Integer, IMobileEntity>();
    private final Map<RenderType, Map<Integer, IEntity>> entities = Collections.synchronizedMap(new EnumMap(RenderType.class));
    private final Map<String, List<IEntity>> entitiesByTag = new ConcurrentHashMap<String, List<IEntity>>();
    private final Map<RenderType, Collection<EnvironmentRenderListener>> renderListeners = Collections.synchronizedMap(new EnumMap(RenderType.class));
    private final List<EnvironmentListener> listeners = new CopyOnWriteArrayList<EnvironmentListener>();
    private final List<EnvironmentEntityListener> entityListeners = new CopyOnWriteArrayList<EnvironmentEntityListener>();
    private final Map<RenderType, Collection<IRenderable>> renderables = Collections.synchronizedMap(new EnumMap(RenderType.class));
    private final Collection<CollisionBox> colliders = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<LightSource> lightSources = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<StaticShadow> staticShadows = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<Trigger> triggers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<Prop> props = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<Emitter> emitters = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<Creature> creatures = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<Spawnpoint> spawnPoints = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Collection<MapArea> mapAreas = Collections.newSetFromMap(new ConcurrentHashMap());
    private AmbientLight ambientLight;
    private StaticShadowLayer staticShadowLayer;
    private boolean loaded;
    private boolean initialized;
    private IMap map;
    private int localIdSequence = 0;
    private int mapIdSequence;

    public Environment(IMap map) {
        this();
        this.map = map;
        this.mapIdSequence = MapUtilities.getMaxMapId(this.getMap());
        Game.getPhysicsEngine().setBounds(this.getMap().getBounds());
    }

    public Environment(String mapPath) {
        this();
        IMap loadedMap = Game.getMap(FileUtilities.getFileName(mapPath));
        this.map = loadedMap == null ? MapLoader.load(mapPath) : loadedMap;
        this.mapIdSequence = MapUtilities.getMaxMapId(this.getMap());
        Game.getPhysicsEngine().setBounds(new Rectangle(this.getMap().getSizeInPixels()));
    }

    private Environment() {
        for (RenderType renderType : RenderType.values()) {
            this.entities.put(renderType, new ConcurrentHashMap());
            this.renderListeners.put(renderType, Collections.newSetFromMap(new ConcurrentHashMap()));
            this.renderables.put(renderType, Collections.newSetFromMap(new ConcurrentHashMap()));
        }
    }

    @Override
    public void addRenderListener(RenderType renderType, EnvironmentRenderListener listener) {
        this.renderListeners.get((Object)renderType).add(listener);
    }

    @Override
    public void removeRenderListener(EnvironmentRenderListener listener) {
        for (Collection<EnvironmentRenderListener> rends : this.renderListeners.values()) {
            rends.remove(listener);
        }
    }

    @Override
    public void addListener(EnvironmentListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(EnvironmentListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addEntityListener(EnvironmentEntityListener listener) {
        this.entityListeners.add(listener);
    }

    @Override
    public void removeEntityListener(EnvironmentEntityListener listener) {
        this.entityListeners.remove(listener);
    }

    @Override
    public void add(IEntity entity) {
        if (entity == null) {
            return;
        }
        if (entity.getMapId() == 0) {
            entity.setMapId(this.getLocalMapId());
        }
        if (entity instanceof Emitter) {
            Emitter emitter = (Emitter)entity;
            this.addEmitter(emitter);
        }
        if (entity instanceof ICombatEntity) {
            this.combatEntities.put(entity.getMapId(), (ICombatEntity)entity);
        }
        if (entity instanceof IMobileEntity) {
            this.mobileEntities.put(entity.getMapId(), (IMobileEntity)entity);
        }
        if (entity instanceof Prop) {
            this.props.add((Prop)entity);
        }
        if (entity instanceof Creature) {
            this.creatures.add((Creature)entity);
        }
        if (entity instanceof CollisionBox) {
            this.colliders.add((CollisionBox)entity);
        }
        if (entity instanceof LightSource) {
            this.lightSources.add((LightSource)entity);
        }
        if (entity instanceof Trigger) {
            this.triggers.add((Trigger)entity);
        }
        if (entity instanceof Spawnpoint) {
            this.spawnPoints.add((Spawnpoint)entity);
        }
        if (entity instanceof StaticShadow) {
            this.staticShadows.add((StaticShadow)entity);
        } else if (entity instanceof MapArea) {
            this.mapAreas.add((MapArea)entity);
        }
        for (String rawTag : entity.getTags()) {
            String tag;
            if (rawTag == null || (tag = rawTag.trim().toLowerCase()).isEmpty()) continue;
            if (this.getEntitiesByTag().containsKey(tag)) {
                this.getEntitiesByTag().get(tag).add(entity);
                continue;
            }
            this.getEntitiesByTag().put(tag, new CopyOnWriteArrayList());
            this.getEntitiesByTag().get(tag).add(entity);
        }
        if (this.loaded) {
            this.load(entity);
        }
        this.entities.get((Object)entity.getRenderType()).put(entity.getMapId(), entity);
        this.fireEntityEvent(l -> l.entityAdded(entity));
    }

    private void addEmitter(Emitter emitter) {
        this.manageEmitterRenderables(emitter, (rends, instance) -> rends.add(instance));
        this.emitters.add(emitter);
    }

    private void removeEmitter(Emitter emitter) {
        this.manageEmitterRenderables(emitter, (rends, instance) -> rends.remove(instance));
        this.emitters.remove(emitter);
    }

    private void manageEmitterRenderables(Emitter emitter, BiConsumer<Collection<IRenderable>, IRenderable> cons) {
        for (RenderType renderType : RenderType.values()) {
            IRenderable renderable;
            if (renderType == RenderType.NONE || (renderable = emitter.getRenderable(renderType)) == null) continue;
            cons.accept(this.getRenderables(renderType), renderable);
        }
        this.emitters.remove(emitter);
    }

    private void updateColorLayers(IEntity entity) {
        if (this.staticShadowLayer != null) {
            this.staticShadowLayer.updateSection(entity.getBoundingBox());
        }
        if (this.ambientLight != null) {
            this.ambientLight.updateSection(entity.getBoundingBox());
        }
    }

    @Override
    public void add(IRenderable renderable, RenderType renderType) {
        this.getRenderables(renderType).add(renderable);
    }

    @Override
    public Collection<IEntity> build(Blueprint blueprint, double x, double y) {
        return this.build(blueprint, new Point2D.Double(x, y));
    }

    @Override
    public Collection<IEntity> build(Blueprint blueprint, Point2D location) {
        List<IMapObject> mapObjects = blueprint.build(location);
        ArrayList<IEntity> loadedEntities = new ArrayList<IEntity>();
        for (IMapObject obj : mapObjects) {
            loadedEntities.addAll(this.load(obj));
        }
        return loadedEntities;
    }

    @Override
    public void clear() {
        Game.getPhysicsEngine().clear();
        this.dispose(this.getEntities());
        this.dispose(this.getTriggers());
        this.getCombatEntities().clear();
        this.getMobileEntities().clear();
        this.getLightSources().clear();
        this.getCollisionBoxes().clear();
        this.getSpawnPoints().clear();
        this.getAreas().clear();
        this.getTriggers().clear();
        this.getEntitiesByTag().clear();
        for (Map<Integer, IEntity> type : this.entities.values()) {
            type.clear();
        }
        this.initialized = false;
        this.fireEvent(l -> l.environmentCleared(this));
    }

    @Override
    public List<ICombatEntity> findCombatEntities(Shape shape) {
        return this.findCombatEntities(shape, entity -> true);
    }

    @Override
    public List<ICombatEntity> findCombatEntities(Shape shape, Predicate<ICombatEntity> condition) {
        ArrayList<ICombatEntity> foundCombatEntities = new ArrayList<ICombatEntity>();
        if (shape == null) {
            return foundCombatEntities;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shape;
            for (ICombatEntity combatEntity : this.getCombatEntities().stream().filter(condition).collect(Collectors.toList())) {
                if (!combatEntity.getHitBox().intersects(rect)) continue;
                foundCombatEntities.add(combatEntity);
            }
            return foundCombatEntities;
        }
        for (ICombatEntity combatEntity : this.getCombatEntities().stream().filter(condition).collect(Collectors.toList())) {
            if (!combatEntity.getHitBox().intersects(shape.getBounds()) || !GeometricUtilities.shapeIntersects(combatEntity.getHitBox(), shape)) continue;
            foundCombatEntities.add(combatEntity);
        }
        return foundCombatEntities;
    }

    @Override
    public List<IEntity> findEntities(Shape shape) {
        ArrayList<IEntity> foundEntities = new ArrayList<IEntity>();
        if (shape == null) {
            return foundEntities;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rect = (Rectangle2D)shape;
            for (IEntity entity : this.getEntities()) {
                if (!entity.getBoundingBox().intersects(rect)) continue;
                foundEntities.add(entity);
            }
            return foundEntities;
        }
        for (IEntity entity : this.getEntities()) {
            if (!entity.getBoundingBox().intersects(shape.getBounds()) || !GeometricUtilities.shapeIntersects(entity.getBoundingBox(), shape)) continue;
            foundEntities.add(entity);
        }
        return foundEntities;
    }

    @Override
    public IEntity get(int mapId) {
        for (RenderType type : RenderType.values()) {
            IEntity entity = this.entities.get((Object)type).get(mapId);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    @Override
    public List<IEntity> get(int ... mapIds) {
        ArrayList<IEntity> foundEntities = new ArrayList<IEntity>();
        if (mapIds == null) {
            return foundEntities;
        }
        for (RenderType type : RenderType.values()) {
            for (int id : mapIds) {
                IEntity entity = this.entities.get((Object)type).get(id);
                if (entity == null) continue;
                foundEntities.add(entity);
            }
        }
        return foundEntities;
    }

    @Override
    public <T extends IEntity> T get(Class<T> clss, int mapId) {
        IEntity ent = this.get(mapId);
        if (ent == null || !clss.isInstance(ent)) {
            return null;
        }
        return (T)((IEntity)clss.cast(ent));
    }

    @Override
    public IEntity get(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (RenderType type : RenderType.values()) {
            for (IEntity entity : this.entities.get((Object)type).values()) {
                if (entity.getName() == null || !entity.getName().equals(name)) continue;
                return entity;
            }
        }
        return null;
    }

    @Override
    public <T extends IEntity> T get(Class<T> clss, String name) {
        IEntity ent = this.get(name);
        if (ent == null || !clss.isInstance(ent)) {
            return null;
        }
        return (T)((IEntity)clss.cast(ent));
    }

    @Override
    public Collection<IEntity> getByTag(String ... tags) {
        ArrayList<IEntity> foundEntities = new ArrayList<IEntity>();
        for (String rawTag : tags) {
            String tag = rawTag.toLowerCase();
            if (!this.getEntitiesByTag().containsKey(tag)) continue;
            foundEntities.addAll((Collection<IEntity>)this.getEntitiesByTag().get(tag));
        }
        return foundEntities;
    }

    @Override
    public <T extends IEntity> Collection<T> getByTag(Class<T> clss, String ... tags) {
        ArrayList<T> foundEntities = new ArrayList<T>();
        for (String rawTag : tags) {
            String tag = rawTag.toLowerCase();
            if (!this.getEntitiesByTag().containsKey(tag)) continue;
            for (IEntity ent : this.getEntitiesByTag().get(tag)) {
                if (foundEntities.contains(ent) || !clss.isInstance(ent)) continue;
                foundEntities.add(clss.cast(ent));
            }
        }
        return foundEntities;
    }

    @Override
    public AmbientLight getAmbientLight() {
        return this.ambientLight;
    }

    @Override
    public Collection<MapArea> getAreas() {
        return this.mapAreas;
    }

    @Override
    public MapArea getArea(int mapId) {
        return Environment.getById(this.getAreas(), mapId);
    }

    @Override
    public MapArea getArea(String name) {
        return Environment.getByName(this.getAreas(), name);
    }

    @Override
    public Collection<Emitter> getEmitters() {
        return this.emitters;
    }

    @Override
    public Emitter getEmitter(int mapId) {
        return Environment.getById(this.getEmitters(), mapId);
    }

    @Override
    public Emitter getEmitter(String name) {
        return Environment.getByName(this.getEmitters(), name);
    }

    @Override
    public Collection<CollisionBox> getCollisionBoxes() {
        return this.colliders;
    }

    @Override
    public CollisionBox getCollisionBox(int mapId) {
        return Environment.getById(this.getCollisionBoxes(), mapId);
    }

    @Override
    public CollisionBox getCollisionBox(String name) {
        return Environment.getByName(this.getCollisionBoxes(), name);
    }

    @Override
    public Collection<ICombatEntity> getCombatEntities() {
        return this.combatEntities.values();
    }

    @Override
    public ICombatEntity getCombatEntity(int mapId) {
        return Environment.getById(this.getCombatEntities(), mapId);
    }

    @Override
    public ICombatEntity getCombatEntity(String name) {
        return Environment.getByName(this.getCombatEntities(), name);
    }

    @Override
    public Collection<IEntity> getEntities() {
        ArrayList<IEntity> ent = new ArrayList<IEntity>();
        for (Map<Integer, IEntity> type : this.entities.values()) {
            ent.addAll(type.values());
        }
        return ent;
    }

    @Override
    public Collection<IEntity> getEntities(RenderType renderType) {
        return this.entities.get((Object)renderType).values();
    }

    @Override
    public Map<String, List<IEntity>> getEntitiesByTag() {
        return this.entitiesByTag;
    }

    @Override
    public <T extends IEntity> Collection<T> getByType(Class<T> cls) {
        ArrayList<T> foundEntities = new ArrayList<T>();
        for (IEntity ent : this.getEntities()) {
            if (!cls.isInstance(ent)) continue;
            foundEntities.add(cls.cast(ent));
        }
        return foundEntities;
    }

    @Override
    public Collection<LightSource> getLightSources() {
        return this.lightSources;
    }

    @Override
    public LightSource getLightSource(int mapId) {
        return Environment.getById(this.getLightSources(), mapId);
    }

    @Override
    public LightSource getLightSource(String name) {
        return Environment.getByName(this.getLightSources(), name);
    }

    @Override
    public synchronized int getLocalMapId() {
        return --this.localIdSequence;
    }

    @Override
    public IMap getMap() {
        return this.map;
    }

    @Override
    public Collection<IMobileEntity> getMobileEntities() {
        return this.mobileEntities.values();
    }

    @Override
    public IMobileEntity getMobileEntity(int mapId) {
        return Environment.getById(this.getMobileEntities(), mapId);
    }

    @Override
    public IMobileEntity getMobileEntity(String name) {
        return Environment.getByName(this.getMobileEntities(), name);
    }

    @Override
    public synchronized int getNextMapId() {
        return ++this.mapIdSequence;
    }

    @Override
    public Collection<IRenderable> getRenderables(RenderType renderType) {
        return this.renderables.get((Object)renderType);
    }

    @Override
    public Collection<Prop> getProps() {
        return this.props;
    }

    @Override
    public Prop getProp(int mapId) {
        return Environment.getById(this.getProps(), mapId);
    }

    @Override
    public Prop getProp(String name) {
        return Environment.getByName(this.getProps(), name);
    }

    @Override
    public Creature getCreature(int mapId) {
        return Environment.getById(this.getCreatures(), mapId);
    }

    @Override
    public Creature getCreature(String name) {
        return Environment.getByName(this.getCreatures(), name);
    }

    @Override
    public Collection<Creature> getCreatures() {
        return this.creatures;
    }

    @Override
    public Spawnpoint getSpawnpoint(int mapId) {
        return Environment.getById(this.getSpawnPoints(), mapId);
    }

    @Override
    public Spawnpoint getSpawnpoint(String name) {
        return Environment.getByName(this.getSpawnPoints(), name);
    }

    @Override
    public Collection<Spawnpoint> getSpawnPoints() {
        return this.spawnPoints;
    }

    @Override
    public Collection<StaticShadow> getStaticShadows() {
        return this.staticShadows;
    }

    @Override
    public StaticShadow getStaticShadow(int mapId) {
        return Environment.getById(this.getStaticShadows(), mapId);
    }

    @Override
    public StaticShadow getStaticShadow(String name) {
        return Environment.getByName(this.getStaticShadows(), name);
    }

    @Override
    public StaticShadowLayer getStaticShadowLayer() {
        return this.staticShadowLayer;
    }

    @Override
    public Trigger getTrigger(int mapId) {
        return Environment.getById(this.getTriggers(), mapId);
    }

    @Override
    public Trigger getTrigger(String name) {
        return Environment.getByName(this.getTriggers(), name);
    }

    @Override
    public Collection<Trigger> getTriggers() {
        return this.triggers;
    }

    @Override
    public List<String> getUsedTags() {
        List<String> tags = this.getEntitiesByTag().keySet().stream().collect(Collectors.toList());
        Collections.sort(tags);
        return tags;
    }

    @Override
    public final void init() {
        if (this.initialized) {
            return;
        }
        this.loadMapObjects();
        this.addStaticShadows();
        this.addAmbientLight();
        this.fireEvent(l -> l.environmentInitialized(this));
        this.initialized = true;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public void load() {
        this.init();
        if (this.loaded) {
            return;
        }
        Game.getPhysicsEngine().setBounds(new Rectangle2D.Double(0.0, 0.0, this.getMap().getSizeInPixels().getWidth(), this.getMap().getSizeInPixels().getHeight()));
        if (this.getMap().getBackgroundColor() != null) {
            Game.getScreenManager().getRenderComponent().setBackground(this.getMap().getBackgroundColor());
        }
        for (IEntity entity : this.getEntities()) {
            this.load(entity);
        }
        this.loaded = true;
        this.fireEvent(l -> l.environmentLoaded(this));
    }

    @Override
    public void loadFromMap(int mapId) {
        for (IMapObjectLayer layer : this.getMap().getMapObjectLayers()) {
            Optional<IMapObject> opt = layer.getMapObjects().stream().filter(mapObject -> mapObject.getType() != null && !mapObject.getType().isEmpty() && mapObject.getId() == mapId).findFirst();
            if (!opt.isPresent()) continue;
            this.load(opt.get());
            break;
        }
    }

    public static void registerMapObjectLoader(IMapObjectLoader mapObjectLoader) {
        mapObjectLoaders.put(mapObjectLoader.getMapObjectType(), mapObjectLoader);
    }

    public static <T extends IEntity> void registerCustomEntityType(String mapObjectType, Class<T> entityType) {
        CustomMapObjectLoader mapObjectLoader = new CustomMapObjectLoader(mapObjectType, entityType);
        Environment.registerMapObjectLoader(mapObjectLoader);
    }

    public static <T extends IEntity> void registerCustomEntityType(Class<T> entityType) {
        EntityInfo info = entityType.getAnnotation(EntityInfo.class);
        if (info == null || info.customMapObjectType().isEmpty()) {
            throw new IllegalArgumentException("Cannot register a custom entity type without the related EntityInfo.customMapObjectType being specified.\n Add an EntityInfo annotation to the " + entityType + " class and provide the required information or use the registerCustomEntityType overload and provide the type explicitly.");
        }
        Environment.registerCustomEntityType(info.customMapObjectType(), entityType);
    }

    @Override
    public void reloadFromMap(int mapId) {
        this.remove(mapId);
        this.loadFromMap(mapId);
    }

    @Override
    public void remove(IEntity entity) {
        if (entity == null) {
            return;
        }
        if (this.entities.get((Object)entity.getRenderType()) != null) {
            this.entities.get((Object)entity.getRenderType()).entrySet().removeIf(e -> ((IEntity)e.getValue()).getMapId() == entity.getMapId());
        }
        for (String tag : entity.getTags()) {
            this.getEntitiesByTag().get(tag).remove(entity);
            if (!this.getEntitiesByTag().get(tag).isEmpty()) continue;
            this.getEntitiesByTag().remove(tag);
        }
        if (entity instanceof Emitter) {
            Emitter emitter = (Emitter)entity;
            this.removeEmitter(emitter);
        }
        if (entity instanceof MapArea) {
            this.mapAreas.remove(entity);
        }
        if (entity instanceof Prop) {
            this.props.remove(entity);
        }
        if (entity instanceof Creature) {
            this.creatures.remove(entity);
        }
        if (entity instanceof CollisionBox) {
            this.colliders.remove(entity);
            this.staticShadows.removeIf(x -> x.getOrigin() != null && x.getOrigin().equals(entity));
        }
        if (entity instanceof LightSource) {
            this.lightSources.remove(entity);
            this.updateColorLayers(entity);
        }
        if (entity instanceof Trigger) {
            this.triggers.remove(entity);
        }
        if (entity instanceof Spawnpoint) {
            this.spawnPoints.remove(entity);
        }
        if (entity instanceof StaticShadow) {
            this.staticShadows.remove(entity);
            this.updateColorLayers(entity);
        }
        if (entity instanceof IMobileEntity) {
            this.mobileEntities.values().remove(entity);
        }
        if (entity instanceof ICombatEntity) {
            this.combatEntities.values().remove(entity);
        }
        this.unload(entity);
        this.fireEntityEvent(l -> l.entityRemoved(entity));
    }

    @Override
    public void remove(int mapId) {
        IEntity ent = this.get(mapId);
        if (ent == null) {
            return;
        }
        this.remove(ent);
    }

    @Override
    public void remove(String name) {
        IEntity ent = this.get(name);
        if (ent == null) {
            return;
        }
        this.remove(ent);
    }

    @Override
    public <T extends IEntity> void remove(Collection<T> entities) {
        if (entities == null) {
            return;
        }
        for (IEntity ent : entities) {
            this.remove(ent);
        }
    }

    @Override
    public void removeRenderable(IRenderable renderable) {
        for (Collection<IRenderable> rends : this.renderables.values()) {
            rends.remove(renderable);
        }
    }

    @Override
    public void render(Graphics2D g) {
        g.scale(Game.getCamera().getRenderScale(), Game.getCamera().getRenderScale());
        StringBuilder renderDetails = new StringBuilder();
        long renderStart = System.nanoTime();
        renderDetails.append(this.render(g, RenderType.BACKGROUND));
        renderDetails.append(this.render(g, RenderType.GROUND));
        if (Game.getConfiguration().debug().isDebug()) {
            DebugRenderer.renderMapDebugInfo(g, this.getMap());
        }
        renderDetails.append(this.render(g, RenderType.SURFACE));
        renderDetails.append(this.render(g, RenderType.NORMAL));
        long shadowRenderStart = System.nanoTime();
        if (this.getStaticShadows().stream().anyMatch(x -> x.getShadowType() != StaticShadowType.NONE)) {
            this.getStaticShadowLayer().render(g);
        }
        double shadowTime = TimeUtilities.nanoToMs(System.nanoTime() - shadowRenderStart);
        renderDetails.append(this.render(g, RenderType.OVERLAY));
        long ambientStart = System.nanoTime();
        if (Game.getConfiguration().graphics().getGraphicQuality().ordinal() >= Quality.MEDIUM.ordinal() && this.getAmbientLight() != null && this.getAmbientLight().getAlpha() != 0) {
            this.getAmbientLight().render(g);
        }
        double ambientTime = TimeUtilities.nanoToMs(System.nanoTime() - ambientStart);
        renderDetails.append(this.render(g, RenderType.UI));
        if (Game.getConfiguration().debug().isLogDetailedRenderTimes()) {
            double totalRenderTime = TimeUtilities.nanoToMs(System.nanoTime() - renderStart);
            log.log(Level.INFO, "total render time: {0}ms \n{1} \tSHADOWS: {2}ms \n\tAMBIENT: {3}ms ", new Object[]{totalRenderTime, renderDetails, shadowTime, ambientTime});
        }
        g.scale(1.0 / (double)Game.getCamera().getRenderScale(), 1.0 / (double)Game.getCamera().getRenderScale());
    }

    private void fireEvent(Consumer<EnvironmentListener> cons) {
        for (EnvironmentListener listener : this.listeners) {
            cons.accept(listener);
        }
    }

    private void fireRenderEvent(Graphics2D g, RenderType type) {
        for (EnvironmentRenderListener listener : this.renderListeners.get((Object)type)) {
            listener.rendered(g, type);
        }
    }

    private void fireEntityEvent(Consumer<EnvironmentEntityListener> cons) {
        for (EnvironmentEntityListener listener : this.entityListeners) {
            cons.accept(listener);
        }
    }

    @Override
    public void unload() {
        if (!this.loaded) {
            return;
        }
        for (IEntity entity : this.getEntities()) {
            this.unload(entity);
        }
        if (Game.getScreenManager() != null && Game.getScreenManager().getRenderComponent() != null) {
            Game.getScreenManager().getRenderComponent().setBackground(RenderComponent.DEFAULT_BACKGROUND_COLOR);
        }
        this.loaded = false;
        this.fireEvent(l -> l.environmentUnloaded(this));
    }

    @Override
    public Collection<IEntity> load(IMapObject mapObject) {
        if (mapObjectLoaders.containsKey(mapObject.getType())) {
            Collection<IEntity> loadedEntities = mapObjectLoaders.get(mapObject.getType()).load(this, mapObject);
            for (IEntity entity : loadedEntities) {
                if (entity == null) continue;
                this.add(entity);
            }
            return loadedEntities;
        }
        return new ArrayList<IEntity>();
    }

    private static <T extends IEntity> T getById(Collection<T> entities, int mapId) {
        for (IEntity m : entities) {
            if (m.getMapId() != mapId) continue;
            return (T)m;
        }
        return null;
    }

    private static <T extends IEntity> T getByName(Collection<T> entities, String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        for (IEntity m : entities) {
            if (m.getName() == null || !m.getName().equals(name)) continue;
            return (T)m;
        }
        return null;
    }

    private String render(Graphics2D g, RenderType renderType) {
        long renderStart = System.nanoTime();
        Game.getRenderEngine().render(g, this.getMap(), renderType);
        for (IRenderable rend : this.getRenderables(renderType)) {
            rend.render(g);
        }
        Game.getRenderEngine().renderEntities(g, this.entities.get((Object)renderType).values(), renderType == RenderType.NORMAL);
        this.fireRenderEvent(g, renderType);
        if (Game.getConfiguration().debug().isLogDetailedRenderTimes()) {
            double renderTime = TimeUtilities.nanoToMs(System.nanoTime() - renderStart);
            return "\t" + (Object)((Object)renderType) + ": " + renderTime + "ms (" + this.getMap().getRenderLayers().stream().filter(m -> m.getRenderType() == renderType).count() + " layers, " + this.getRenderables(renderType).size() + " renderables, " + this.entities.get((Object)renderType).size() + " entities)\n";
        }
        return null;
    }

    private void addAmbientLight() {
        int ambientAlpha = this.getMap().getCustomPropertyInt("AMBIENTALPHA");
        Color ambientColor = this.getMap().getCustomPropertyColor("AMBIENTLIGHT", Color.WHITE);
        this.ambientLight = new AmbientLight(this, ambientColor, ambientAlpha);
    }

    private void addStaticShadows() {
        int alpha = this.getMap().getCustomPropertyInt("SHADOWALPHA", 75);
        Color color = this.getMap().getCustomPropertyColor("SHADOWCOLOR", StaticShadow.DEFAULT_COLOR);
        this.staticShadowLayer = new StaticShadowLayer((IEnvironment)this, alpha, color);
    }

    private void dispose(Collection<? extends IEntity> entities) {
        for (IEntity iEntity : entities) {
            if (iEntity instanceof IUpdateable) {
                Game.getLoop().detach((IUpdateable)((Object)iEntity));
            }
            iEntity.detachControllers();
        }
    }

    private void load(IEntity entity) {
        this.loadPhysicsEntity(entity);
        this.loadUpdatableOrEmitterEntity(entity);
        entity.attachControllers();
        if (entity instanceof LightSource || entity instanceof StaticShadow) {
            this.updateColorLayers(entity);
        }
        entity.loaded();
    }

    private void loadPhysicsEntity(IEntity entity) {
        ICollisionEntity coll;
        if (entity instanceof CollisionBox) {
            CollisionBox coll2 = (CollisionBox)entity;
            if (coll2.isObstacle()) {
                Game.getPhysicsEngine().add(coll2.getBoundingBox());
            } else {
                Game.getPhysicsEngine().add(coll2);
            }
        } else if (entity instanceof ICollisionEntity && (coll = (ICollisionEntity)entity).hasCollision()) {
            Game.getPhysicsEngine().add(coll);
        }
    }

    private void loadUpdatableOrEmitterEntity(IEntity entity) {
        if (entity instanceof Emitter) {
            Emitter emitter = (Emitter)entity;
            if (emitter.isActivateOnInit()) {
                emitter.activate();
            }
        } else if (entity instanceof IUpdateable) {
            Game.getLoop().attach((IUpdateable)((Object)entity));
        }
    }

    private void loadMapObjects() {
        for (IMapObjectLayer layer : this.getMap().getMapObjectLayers()) {
            for (IMapObject mapObject : layer.getMapObjects()) {
                if (mapObject.getType() == null || mapObject.getType().isEmpty()) continue;
                this.load(mapObject);
            }
        }
    }

    private static void registerDefaultMapObjectLoaders() {
        Environment.registerMapObjectLoader(new PropMapObjectLoader());
        Environment.registerMapObjectLoader(new CollisionBoxMapObjectLoader());
        Environment.registerMapObjectLoader(new TriggerMapObjectLoader());
        Environment.registerMapObjectLoader(new EmitterMapObjectLoader());
        Environment.registerMapObjectLoader(new LightSourceMapObjectLoader());
        Environment.registerMapObjectLoader(new SpawnpointMapObjectLoader());
        Environment.registerMapObjectLoader(new MapAreaMapObjectLoader());
        Environment.registerMapObjectLoader(new StaticShadowMapObjectLoader());
        Environment.registerMapObjectLoader(new CreatureMapObjectLoader());
    }

    private void unload(IEntity entity) {
        ICollisionEntity coll;
        if (entity instanceof CollisionBox) {
            coll = (CollisionBox)entity;
            if (((CollisionBox)coll).isObstacle()) {
                Game.getPhysicsEngine().remove(((Entity)((Object)coll)).getBoundingBox());
            } else {
                Game.getPhysicsEngine().remove(coll);
            }
        } else if (entity instanceof ICollisionEntity) {
            coll = (ICollisionEntity)entity;
            Game.getPhysicsEngine().remove(coll);
        }
        if (entity instanceof IUpdateable) {
            Game.getLoop().detach((IUpdateable)((Object)entity));
        }
        entity.detachControllers();
        if (entity instanceof Emitter) {
            Emitter em = (Emitter)entity;
            em.deactivate();
        }
        entity.removed();
    }

    static {
        Environment.registerDefaultMapObjectLoaders();
    }
}

