/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import de.gurkenlabs.litiengine.environment.tilemap.xml.MapObject;
import de.gurkenlabs.litiengine.graphics.emitters.particles.ParticleType;
import de.gurkenlabs.litiengine.graphics.emitters.xml.CustomEmitter;
import de.gurkenlabs.litiengine.graphics.emitters.xml.EmitterData;
import de.gurkenlabs.litiengine.graphics.emitters.xml.ParticleColor;
import de.gurkenlabs.litiengine.graphics.emitters.xml.ParticleParameter;
import de.gurkenlabs.litiengine.physics.CollisionType;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EmitterMapObjectLoader
extends MapObjectLoader {
    protected EmitterMapObjectLoader() {
        super(MapObjectType.EMITTER);
    }

    public static List<ParticleColor> getColors(IMapObject emitter) {
        ArrayList<ParticleColor> particleColors = new ArrayList<ParticleColor>();
        String colorsString = emitter.getCustomProperty("emitterColors", "");
        if (colorsString != null && !colorsString.isEmpty()) {
            String[] colors;
            for (String color : colors = colorsString.split(",")) {
                ParticleColor particleColor = ParticleColor.decode(color);
                if (particleColor == null) continue;
                particleColors.add(particleColor);
            }
        }
        return particleColors;
    }

    @Override
    public Collection<IEntity> load(IEnvironment environment, IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.EMITTER) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + EmitterMapObjectLoader.class);
        }
        EmitterData data = EmitterMapObjectLoader.createEmitterData(mapObject);
        CustomEmitter emitter = this.createCustomEmitter(data);
        EmitterMapObjectLoader.loadDefaultProperties(emitter, mapObject);
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        entities.add(emitter);
        return entities;
    }

    protected CustomEmitter createCustomEmitter(EmitterData data) {
        return new CustomEmitter(data);
    }

    public static EmitterData createEmitterData(IMapObject mapObject) {
        EmitterData data = new EmitterData();
        data.setWidth(mapObject.getWidth());
        data.setHeight(mapObject.getHeight());
        data.setSpawnRate(mapObject.getCustomPropertyInt("emitterSpawnRate"));
        data.setSpawnAmount(mapObject.getCustomPropertyInt("emitterSpawnAmount"));
        data.setUpdateRate(mapObject.getCustomPropertyInt("emitterUpdateDelay", 30));
        data.setEmitterTTL(mapObject.getCustomPropertyInt("emitterTimeToLive"));
        data.setMaxParticles(mapObject.getCustomPropertyInt("emitterMaxParticles"));
        data.setParticleType(mapObject.getCustomPropertyEnum("emitterParticleType", ParticleType.class, ParticleType.RECTANGLE));
        data.setColorDeviation(mapObject.getCustomPropertyFloat("emitterColorDeviation"));
        data.setAlphaDeviation(mapObject.getCustomPropertyFloat("emitterAlphaDeviation"));
        data.setOriginAlign(mapObject.getCustomPropertyEnum("emitterOriginAlign", Align.class, Align.LEFT));
        data.setOriginValign(mapObject.getCustomPropertyEnum("emitterOriginValign", Valign.class, Valign.TOP));
        data.setColors(EmitterMapObjectLoader.getColors(mapObject));
        data.setColorProbabilities(mapObject.getCustomProperty("emitterColorProbabilities", ""));
        data.setParticleX(new ParticleParameter(mapObject.getCustomPropertyFloat("particleMinX"), mapObject.getCustomPropertyFloat("particleMaxX", -1.0f)));
        data.setParticleY(new ParticleParameter(mapObject.getCustomPropertyFloat("particleMinY"), mapObject.getCustomPropertyFloat("particleMaxY", -1.0f)));
        data.setParticleWidth(new ParticleParameter(mapObject.getCustomPropertyFloat("particleMinStartWidth"), mapObject.getCustomPropertyFloat("particleMaxStartWidth", -1.0f)));
        data.setParticleHeight(new ParticleParameter(mapObject.getCustomPropertyFloat("particleMinStartHeight"), mapObject.getCustomPropertyFloat("particleMaxStartHeight", -1.0f)));
        data.setDeltaX(new ParticleParameter(mapObject.getCustomPropertyFloat("particleMinDeltaX"), mapObject.getCustomPropertyFloat("particleMaxDeltaX", -1.0f)));
        data.setDeltaY(new ParticleParameter(mapObject.getCustomPropertyFloat("particleMinDeltaY"), mapObject.getCustomPropertyFloat("particleMaxDeltaY", -1.0f)));
        data.setGravityX(new ParticleParameter(mapObject.getCustomPropertyFloat("particleMinGravityX"), mapObject.getCustomPropertyFloat("particleMaxGravityX", -1.0f)));
        data.setGravityY(new ParticleParameter(mapObject.getCustomPropertyFloat("particleMinGravityY"), mapObject.getCustomPropertyFloat("particleMaxGravityY", -1.0f)));
        data.setDeltaWidth(new ParticleParameter(mapObject.getCustomPropertyFloat("particleMinDeltaWidth"), mapObject.getCustomPropertyFloat("particleMaxDeltaWidth", -1.0f)));
        data.setDeltaHeight(new ParticleParameter(mapObject.getCustomPropertyFloat("particleMinDeltaHeight"), mapObject.getCustomPropertyFloat("particleMaxDeltaHeight", -1.0f)));
        data.setParticleMinTTL(mapObject.getCustomPropertyInt("particleMinTTL"));
        data.setParticleMaxTTL(mapObject.getCustomPropertyInt("particleMaxTTL"));
        data.setCollisionType(mapObject.getCustomPropertyEnum("particlePhysics", CollisionType.class, CollisionType.NONE));
        data.setParticleText(mapObject.getCustomProperty("particleText"));
        data.setSpritesheet(mapObject.getCustomProperty("particleSprite"));
        data.setAnimateSprite(mapObject.getCustomPropertyBool("particleAnimateSprite"));
        data.setFade(mapObject.getCustomPropertyBool("particleFade"));
        return data;
    }

    public static IMapObject createMapObject(EmitterData emitterData) {
        MapObject newMapObject = new MapObject();
        newMapObject.setType(MapObjectType.EMITTER.toString());
        newMapObject.setWidth(emitterData.getWidth());
        newMapObject.setHeight(emitterData.getHeight());
        newMapObject.setCustomProperty("emitterSpawnRate", Integer.toString(emitterData.getSpawnRate()));
        newMapObject.setCustomProperty("emitterSpawnAmount", Integer.toString(emitterData.getSpawnAmount()));
        newMapObject.setCustomProperty("emitterUpdateDelay", Integer.toString(emitterData.getUpdateRate()));
        newMapObject.setCustomProperty("emitterTimeToLive", Integer.toString(emitterData.getEmitterTTL()));
        newMapObject.setCustomProperty("emitterMaxParticles", Integer.toString(emitterData.getMaxParticles()));
        newMapObject.setCustomProperty("emitterParticleType", emitterData.getParticleType().name());
        newMapObject.setCustomProperty("emitterColorDeviation", Float.toString(emitterData.getColorDeviation()));
        newMapObject.setCustomProperty("emitterAlphaDeviation", Float.toString(emitterData.getAlphaDeviation()));
        newMapObject.setCustomProperty("emitterOriginAlign", emitterData.getOriginAlign().name());
        newMapObject.setCustomProperty("emitterOriginValign", emitterData.getOriginValign().name());
        String commaSeperatedColors = ArrayUtilities.getCommaSeparatedString(emitterData.getColors());
        newMapObject.setCustomProperty("emitterColors", commaSeperatedColors);
        newMapObject.setCustomProperty("emitterParticleType", ArrayUtilities.getCommaSeparatedString(emitterData.getColorProbabilities()));
        newMapObject.setCustomProperty("particleMinX", Float.toString(emitterData.getParticleX().getMinValue()));
        newMapObject.setCustomProperty("particleMinY", Float.toString(emitterData.getParticleY().getMinValue()));
        newMapObject.setCustomProperty("particleMinStartWidth", Float.toString(emitterData.getParticleWidth().getMinValue()));
        newMapObject.setCustomProperty("particleMinStartHeight", Float.toString(emitterData.getParticleHeight().getMinValue()));
        newMapObject.setCustomProperty("particleMinDeltaX", Float.toString(emitterData.getDeltaX().getMinValue()));
        newMapObject.setCustomProperty("particleMinDeltaY", Float.toString(emitterData.getDeltaY().getMinValue()));
        newMapObject.setCustomProperty("particleMinGravityX", Float.toString(emitterData.getGravityX().getMinValue()));
        newMapObject.setCustomProperty("particleMinGravityY", Float.toString(emitterData.getGravityY().getMinValue()));
        newMapObject.setCustomProperty("particleMinDeltaWidth", Float.toString(emitterData.getDeltaWidth().getMinValue()));
        newMapObject.setCustomProperty("particleMinDeltaHeight", Float.toString(emitterData.getDeltaHeight().getMinValue()));
        newMapObject.setCustomProperty("particleMaxX", Float.toString(emitterData.getParticleX().getMaxValue()));
        newMapObject.setCustomProperty("particleMaxY", Float.toString(emitterData.getParticleY().getMaxValue()));
        newMapObject.setCustomProperty("particleMaxStartWidth", Float.toString(emitterData.getParticleWidth().getMaxValue()));
        newMapObject.setCustomProperty("particleMaxStartHeight", Float.toString(emitterData.getParticleHeight().getMaxValue()));
        newMapObject.setCustomProperty("particleMaxDeltaX", Float.toString(emitterData.getDeltaX().getMaxValue()));
        newMapObject.setCustomProperty("particleMaxDeltaY", Float.toString(emitterData.getDeltaY().getMaxValue()));
        newMapObject.setCustomProperty("particleMaxGravityX", Float.toString(emitterData.getGravityX().getMaxValue()));
        newMapObject.setCustomProperty("particleMaxGravityY", Float.toString(emitterData.getGravityY().getMaxValue()));
        newMapObject.setCustomProperty("particleMaxDeltaWidth", Float.toString(emitterData.getDeltaWidth().getMaxValue()));
        newMapObject.setCustomProperty("particleMaxDeltaHeight", Float.toString(emitterData.getDeltaHeight().getMaxValue()));
        newMapObject.setCustomProperty("particleMinTTL", Integer.toString(emitterData.getParticleMinTTL()));
        newMapObject.setCustomProperty("particleMaxTTL", Integer.toString(emitterData.getParticleMaxTTL()));
        newMapObject.setCustomProperty("particlePhysics", emitterData.getCollisionType().toString());
        newMapObject.setCustomProperty("particleText", emitterData.getParticleText());
        newMapObject.setCustomProperty("particleSprite", emitterData.getSpritesheet());
        newMapObject.setCustomProperty("particleAnimateSprite", Boolean.toString(emitterData.isAnimateSprite()));
        newMapObject.setCustomProperty("particleFade", Boolean.toString(emitterData.isFading()));
        return newMapObject;
    }
}

