/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.MapObjectException;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;

public final class CustomMapObjectLoader
extends MapObjectLoader {
    private final ConstructorInvocation invoke;

    protected CustomMapObjectLoader(String mapObjectType, Class<? extends IEntity> entityType) {
        super(mapObjectType);
        ConstructorInvocation invoke;
        if (entityType.isInterface()) {
            throw new IllegalArgumentException("Cannot create loader for interface or abstract class");
        }
        try {
            Constructor<? extends IEntity> constructor = entityType.getConstructor(IEnvironment.class, IEnvironment.class);
            invoke = (e, o) -> (IEntity)constructor.newInstance(e, o);
        }
        catch (NoSuchMethodException e1) {
            try {
                Constructor<? extends IEntity> constructor = entityType.getConstructor(IMapObject.class, IEnvironment.class);
                invoke = (e, o) -> (IEntity)constructor.newInstance(o, e);
            }
            catch (NoSuchMethodException e2) {
                try {
                    Constructor<? extends IEntity> constructor = entityType.getConstructor(IMapObject.class);
                    invoke = (e, o) -> (IEntity)constructor.newInstance(o);
                }
                catch (NoSuchMethodException e3) {
                    try {
                        Constructor<? extends IEntity> constructor = entityType.getConstructor(IEnvironment.class);
                        invoke = (e, o) -> (IEntity)constructor.newInstance(e);
                    }
                    catch (NoSuchMethodException e4) {
                        try {
                            Constructor<? extends IEntity> constructor = entityType.getConstructor(new Class[0]);
                            invoke = (e, o) -> (IEntity)constructor.newInstance(new Object[0]);
                        }
                        catch (NoSuchMethodException e5) {
                            throw new IllegalArgumentException("Entity class is missing a usable constructor");
                        }
                    }
                }
            }
        }
        this.invoke = invoke;
    }

    @Override
    public Collection<IEntity> load(IEnvironment environment, IMapObject mapObject) {
        IEntity entity;
        try {
            entity = this.invoke.invoke(environment, mapObject);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new MapObjectException(cause);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new MapObjectException(e);
        }
        CustomMapObjectLoader.loadDefaultProperties(entity, mapObject);
        if (entity instanceof ICollisionEntity) {
            CustomMapObjectLoader.loadCollisionProperties((ICollisionEntity)entity, mapObject);
        }
        return Arrays.asList(entity);
    }

    @FunctionalInterface
    private static interface ConstructorInvocation {
        public IEntity invoke(IEnvironment var1, IMapObject var2) throws InvocationTargetException, IllegalAccessException, InstantiationException;
    }
}

