/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.environment;

import de.gurkenlabs.litiengine.entities.CollisionBox;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.StaticShadow;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.MapObjectLoader;
import de.gurkenlabs.litiengine.environment.tilemap.IMapObject;
import de.gurkenlabs.litiengine.environment.tilemap.MapObjectType;
import java.util.ArrayList;
import java.util.Collection;

public class CollisionBoxMapObjectLoader
extends MapObjectLoader {
    protected CollisionBoxMapObjectLoader() {
        super(MapObjectType.COLLISIONBOX);
    }

    @Override
    public Collection<IEntity> load(IEnvironment environment, IMapObject mapObject) {
        if (MapObjectType.get(mapObject.getType()) != MapObjectType.COLLISIONBOX) {
            throw new IllegalArgumentException("Cannot load a mapobject of the type " + mapObject.getType() + " with a loader of the type " + CollisionBoxMapObjectLoader.class);
        }
        boolean isObstacle = mapObject.getCustomPropertyBool("isObstacle", true);
        boolean isObstructingLight = mapObject.getCustomPropertyBool("isObstructingLight");
        CollisionBox col = this.createCollisionBox(mapObject, isObstacle, isObstructingLight);
        CollisionBoxMapObjectLoader.loadDefaultProperties(col, mapObject);
        col.setCollisionBoxWidth(col.getWidth());
        col.setCollisionBoxHeight(col.getHeight());
        ArrayList<IEntity> entities = new ArrayList<IEntity>();
        entities.add(col);
        if (isObstructingLight) {
            entities.add(new StaticShadow(col));
        }
        return entities;
    }

    protected CollisionBox createCollisionBox(IMapObject mapObject, boolean isObstacle, boolean isObstructingLight) {
        return new CollisionBox(isObstacle, isObstructingLight);
    }
}

