/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.annotation.AnimationInfo;
import de.gurkenlabs.litiengine.entities.CombatEntity;
import de.gurkenlabs.litiengine.entities.Material;
import de.gurkenlabs.litiengine.entities.PropState;
import de.gurkenlabs.litiengine.entities.Rotation;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.graphics.animation.PropAnimationController;
import java.awt.geom.Point2D;

@AnimationInfo(spritePrefix={"prop-"})
public class Prop
extends CombatEntity {
    @TmxProperty(name="material")
    private Material material;
    @TmxProperty(name="isObstacle")
    private boolean isObstacle;
    @TmxProperty(name="addShadow")
    private boolean addShadow;
    @TmxProperty(name="flipHorizontally")
    private boolean flipHorizontally;
    @TmxProperty(name="flipVertically")
    private boolean flipVertically;
    @TmxProperty(name="scaling")
    private boolean scaling;
    @TmxProperty(name="rotationSprite")
    private Rotation rotation = Rotation.NONE;
    @TmxProperty(name="spritesheetName")
    private String spritesheetName;

    public Prop(String spritesheetName) {
        this(0.0, 0.0, spritesheetName);
    }

    public Prop(double x, double y, String spritesheetName) {
        this(x, y, spritesheetName, Material.UNDEFINED);
    }

    public Prop(double x, double y, String spritesheetName, Material mat) {
        this(new Point2D.Double(x, y), spritesheetName, mat);
    }

    public Prop(Point2D location, String spritesheetName) {
        this(location, spritesheetName, Material.UNDEFINED);
    }

    public Prop(Point2D location, String spritesheetName, Material mat) {
        this.spritesheetName = spritesheetName;
        this.material = mat;
        this.setLocation(location);
        this.updateAnimationController();
    }

    public Material getMaterial() {
        return this.material;
    }

    public String getSpritesheetName() {
        return this.spritesheetName;
    }

    public PropState getState() {
        if (!this.isIndestructible() && this.getAttributes().getHealth().getCurrentValue() <= 0) {
            return PropState.DESTROYED;
        }
        if (!this.isIndestructible() && (double)this.getAttributes().getHealth().getCurrentValue().intValue() <= (double)this.getAttributes().getHealth().getMaxValue().intValue() * 0.5) {
            return PropState.DAMAGED;
        }
        return PropState.INTACT;
    }

    public boolean isAddShadow() {
        return this.addShadow;
    }

    public boolean isObstacle() {
        return this.isObstacle;
    }

    public boolean isScaling() {
        return this.scaling;
    }

    public boolean flipHorizontally() {
        return this.flipHorizontally;
    }

    public boolean flipVertically() {
        return this.flipVertically;
    }

    public Rotation getSpriteRotation() {
        return this.rotation;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public void setSpritesheetName(String spriteName) {
        this.spritesheetName = spriteName;
        this.updateAnimationController();
    }

    public void setObstacle(boolean isObstacle) {
        this.isObstacle = isObstacle;
    }

    public void setAddShadow(boolean addShadow) {
        this.addShadow = addShadow;
    }

    public void setScaling(boolean scaling) {
        this.scaling = scaling;
    }

    @Override
    public boolean isDead() {
        if (this.isIndestructible()) {
            return false;
        }
        return this.getAttributes().getHealth().getCurrentValue() <= 0;
    }

    public void setSpriteRotation(Rotation spriteRotation) {
        this.rotation = spriteRotation;
    }

    public void setFlipHorizontally(boolean flipHorizontally) {
        this.flipHorizontally = flipHorizontally;
    }

    public void setFlipVertically(boolean flipVertically) {
        this.flipVertically = flipVertically;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null && !this.getName().isEmpty()) {
            sb.append(this.getName());
        } else {
            sb.append(Prop.class.getSimpleName());
        }
        sb.append(" (");
        sb.append(this.getSpritesheetName());
        sb.append(") #");
        sb.append(this.getMapId());
        return sb.toString();
    }

    private void updateAnimationController() {
        PropAnimationController<Prop> controller = new PropAnimationController<Prop>(this);
        this.getControllers().addController(controller);
        if (Game.getEnvironment() != null && Game.getEnvironment().isLoaded()) {
            Game.getLoop().attach(controller);
        }
    }
}

