/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.annotation.MovementInfo;
import de.gurkenlabs.litiengine.entities.CollisionEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.physics.IMovementController;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;

@MovementInfo
public class MobileEntity
extends CollisionEntity
implements IMobileEntity {
    private int acceleration;
    private int deceleration;
    private Point2D moveDestination;
    private boolean turnOnMove;
    private short velocity;

    public MobileEntity() {
        MovementInfo info = this.getClass().getAnnotation(MovementInfo.class);
        this.velocity = info.velocity();
        this.acceleration = info.acceleration();
        this.deceleration = info.deceleration();
        this.setTurnOnMove(info.turnOnMove());
    }

    @Override
    public int getAcceleration() {
        return this.acceleration;
    }

    @Override
    public int getDeceleration() {
        return this.deceleration;
    }

    @Override
    public Point2D getMoveDestination() {
        return this.moveDestination;
    }

    @Override
    public float getTickVelocity() {
        return MobileEntity.getTickVelocity(this);
    }

    @Override
    public float getVelocity() {
        return this.velocity;
    }

    @Override
    public IMovementController getMovementController() {
        return this.getController(IMovementController.class);
    }

    @Override
    public void setAcceleration(int acceleration) {
        this.acceleration = acceleration;
    }

    @Override
    public void setDeceleration(int deceleration) {
        this.deceleration = deceleration;
    }

    @Override
    public void setLocation(Point2D position) {
        if (position == null || GeometricUtilities.equals(position, this.getLocation(), 0.001)) {
            return;
        }
        super.setLocation(position);
    }

    @Override
    public void setMoveDestination(Point2D dest) {
        this.moveDestination = dest;
    }

    @Override
    public void setTurnOnMove(boolean turn) {
        this.turnOnMove = turn;
    }

    @Override
    public void setVelocity(short velocity) {
        this.velocity = velocity;
    }

    @Override
    public boolean turnOnMove() {
        return this.turnOnMove;
    }

    protected static float getTickVelocity(IMobileEntity entity) {
        return (float)Math.min(Game.getLoop().getDeltaTime(), 67L) * 0.001f * entity.getVelocity() * Game.getLoop().getTimeScale();
    }
}

