/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.annotation.EntityInfo;
import de.gurkenlabs.litiengine.annotation.Tag;
import de.gurkenlabs.litiengine.entities.EntityControllers;
import de.gurkenlabs.litiengine.entities.EntityListener;
import de.gurkenlabs.litiengine.entities.EntityTransformListener;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.IEntityController;
import de.gurkenlabs.litiengine.entities.MessageEvent;
import de.gurkenlabs.litiengine.entities.MessageListener;
import de.gurkenlabs.litiengine.entities.ai.IBehaviorController;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import de.gurkenlabs.litiengine.graphics.RenderType;
import de.gurkenlabs.litiengine.graphics.animation.IEntityAnimationController;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@EntityInfo
public abstract class Entity
implements IEntity {
    public static final String ANY_MESSAGE = "";
    private final List<EntityTransformListener> transformListeners = new CopyOnWriteArrayList<EntityTransformListener>();
    private final List<EntityListener> listeners = new CopyOnWriteArrayList<EntityListener>();
    private final Map<String, List<MessageListener>> messageListeners = new ConcurrentHashMap<String, List<MessageListener>>();
    @TmxProperty(name="tags")
    private final List<String> tags = new CopyOnWriteArrayList<String>();
    private final EntityControllers controllers = new EntityControllers();
    private float angle;
    private Rectangle2D boundingBox;
    private float height;
    private int mapId;
    private Point2D mapLocation = new Point2D.Double(0.0, 0.0);
    private String name;
    private RenderType renderType;
    private float width;

    protected Entity() {
        Tag[] tagAnnotations;
        EntityInfo info = this.getClass().getAnnotation(EntityInfo.class);
        this.width = info.width();
        this.height = info.height();
        this.renderType = info.renderType();
        for (Tag t : tagAnnotations = (Tag[])this.getClass().getAnnotationsByType(Tag.class)) {
            this.addTag(t.value());
        }
    }

    protected Entity(int mapId) {
        this();
        this.mapId = mapId;
    }

    protected Entity(String name) {
        this();
        this.name = name;
    }

    protected Entity(int mapId, String name) {
        this(mapId);
        this.name = name;
    }

    @Override
    public void addTransformListener(EntityTransformListener listener) {
        this.transformListeners.add(listener);
    }

    @Override
    public void attachControllers() {
        this.controllers.attachAll();
    }

    @Override
    public void detachControllers() {
        this.controllers.detachAll();
    }

    @Override
    public void removeTransformListener(EntityTransformListener listener) {
        this.transformListeners.remove(listener);
    }

    @Override
    public void addListener(EntityListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(EntityListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void addMessageListener(MessageListener listener) {
        this.addMessageListener(ANY_MESSAGE, listener);
    }

    @Override
    public void addMessageListener(String message, MessageListener listener) {
        if (!this.messageListeners.containsKey(message)) {
            this.messageListeners.put(message, new CopyOnWriteArrayList());
        }
        this.messageListeners.get(message).add(listener);
    }

    @Override
    public void removeMessageListener(MessageListener listener) {
        for (List<MessageListener> listeners : this.messageListeners.values()) {
            if (listeners == null || listeners.isEmpty()) continue;
            listeners.remove(listener);
        }
    }

    @Override
    public float getAngle() {
        return this.angle;
    }

    @Override
    public IEntityAnimationController getAnimationController() {
        return this.getController(IEntityAnimationController.class);
    }

    @Override
    public IBehaviorController getBehaviorController() {
        return this.getController(IBehaviorController.class);
    }

    @Override
    public void addController(IEntityController controller) {
        this.controllers.addController(controller);
    }

    @Override
    public <T extends IEntityController> void setController(Class<T> clss, T controller) {
        this.controllers.setController(clss, controller);
    }

    @Override
    public <T extends IEntityController> T getController(Class<T> clss) {
        return this.controllers.getController(clss);
    }

    @Override
    public Rectangle2D getBoundingBox() {
        if (this.boundingBox != null) {
            return this.boundingBox;
        }
        this.boundingBox = new Rectangle2D.Double(this.getLocation().getX(), this.getLocation().getY(), this.getWidth(), this.getHeight());
        return this.boundingBox;
    }

    @Override
    public Point2D getCenter() {
        return new Point2D.Double(this.getLocation().getX() + (double)this.getWidth() * 0.5, this.getLocation().getY() + (double)this.getHeight() * 0.5);
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public Point2D getLocation() {
        return this.mapLocation;
    }

    @Override
    public int getMapId() {
        return this.mapId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public double getX() {
        return this.getLocation().getX();
    }

    @Override
    public double getY() {
        return this.getLocation().getY();
    }

    @Override
    public String sendMessage(Object sender, String message) {
        MessageEvent event = this.fireMessageReceived(sender, ANY_MESSAGE, message, null);
        this.fireMessageReceived(sender, message, message, event);
        return null;
    }

    @Override
    public void setHeight(float height) {
        this.height = height;
        this.boundingBox = null;
        this.fireSizeChangedEvent();
    }

    @Override
    public void setLocation(double x, double y) {
        this.setLocation(new Point2D.Double(x, y));
    }

    @Override
    public void setLocation(Point2D location) {
        this.mapLocation = location;
        this.boundingBox = null;
        this.fireLocationChangedEvent();
    }

    @Override
    public void setMapId(int mapId) {
        this.mapId = mapId;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setRenderType(RenderType renderType) {
        this.renderType = renderType;
    }

    @Override
    public void setSize(float width, float height) {
        this.width = width;
        this.height = height;
        this.boundingBox = null;
        this.fireSizeChangedEvent();
    }

    @Override
    public void setWidth(float width) {
        this.width = width;
        this.boundingBox = null;
        this.fireSizeChangedEvent();
    }

    @Override
    public void setX(double x) {
        this.setLocation(x, this.getY());
    }

    @Override
    public void setY(double y) {
        this.setLocation(this.getX(), y);
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public boolean hasTag(String tag) {
        return this.tags.contains(tag);
    }

    @Override
    public void addTag(String tag) {
        if (!this.getTags().contains(tag)) {
            this.getTags().add(tag);
        }
        if (Game.getEnvironment() == null) {
            return;
        }
        if (Game.getEnvironment().getEntitiesByTag().containsKey(tag)) {
            Game.getEnvironment().getEntitiesByTag().get(tag).add(this);
            return;
        }
        Game.getEnvironment().getEntitiesByTag().put(tag, new CopyOnWriteArrayList());
        Game.getEnvironment().getEntitiesByTag().get(tag).add(this);
    }

    @Override
    public void removeTag(String tag) {
        this.getTags().remove(tag);
        if (Game.getEnvironment() == null) {
            return;
        }
        Game.getEnvironment().getEntitiesByTag().get(tag).remove(this);
        if (Game.getEnvironment().getEntitiesByTag().get(tag).isEmpty()) {
            Game.getEnvironment().getEntitiesByTag().remove(tag);
        }
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getName() != null && !this.getName().isEmpty()) {
            sb.append(this.getName());
        } else {
            sb.append(this.getClass().getSimpleName());
        }
        sb.append(" #");
        sb.append(this.getMapId());
        return sb.toString();
    }

    @Override
    public void loaded() {
        for (EntityListener listener : this.listeners) {
            listener.loaded(this);
        }
    }

    @Override
    public void removed() {
        for (EntityListener listener : this.listeners) {
            listener.removed(this);
        }
    }

    protected EntityControllers getControllers() {
        return this.controllers;
    }

    private void fireSizeChangedEvent() {
        for (EntityTransformListener listener : this.transformListeners) {
            listener.sizeChanged(this);
        }
    }

    private void fireLocationChangedEvent() {
        for (EntityTransformListener listener : this.transformListeners) {
            listener.locationChanged(this);
        }
    }

    private MessageEvent fireMessageReceived(Object sender, String listenerMessage, String message, MessageEvent event) {
        if (message == null) {
            return event;
        }
        if (this.messageListeners.containsKey(listenerMessage) && this.messageListeners.get(listenerMessage) != null) {
            MessageEvent receivedEvent = event;
            for (MessageListener listener : this.messageListeners.get(listenerMessage)) {
                if (receivedEvent == null) {
                    receivedEvent = new MessageEvent(sender, this, message);
                }
                listener.messageReceived(receivedEvent);
            }
        }
        return event;
    }
}

