/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.annotation.CombatAttributesInfo;
import de.gurkenlabs.litiengine.attributes.Attribute;
import de.gurkenlabs.litiengine.attributes.AttributeModifier;
import de.gurkenlabs.litiengine.attributes.Modification;
import de.gurkenlabs.litiengine.attributes.RangeAttribute;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class CombatAttributes {
    private static final float LEVEL_MULTIPLIER = 1.1f;
    private final Attribute<Float> attackSpeed;
    private final Attribute<Float> damageMultiplier;
    private final RangeAttribute<Integer> experience;
    private final RangeAttribute<Integer> health;
    private final Attribute<Byte> healthRegeneration;
    private final CombatAttributesInfo info;
    private final RangeAttribute<Byte> level;
    private final List<Consumer<CombatAttributes>> levelUpConsumer = new CopyOnWriteArrayList<Consumer<CombatAttributes>>();
    private final RangeAttribute<Short> shield;
    private final Attribute<Float> velocity;
    private final Attribute<Integer> vision;

    public CombatAttributes(CombatAttributesInfo info) {
        this.info = info;
        this.health = new RangeAttribute<Integer>(info.health(), 0, info.health());
        this.shield = new RangeAttribute<Short>(info.maxShield(), (short)0, info.shield());
        this.level = new RangeAttribute<Byte>(info.maxLevel(), (byte)0, info.level());
        this.experience = new RangeAttribute<Integer>(info.maxExperience(), 0, 0);
        this.velocity = new Attribute<Float>(Float.valueOf(info.velocityFactor()));
        this.attackSpeed = new Attribute<Float>(Float.valueOf(info.attackSpeed()));
        this.damageMultiplier = new Attribute<Float>(Float.valueOf(info.damageMultiplier()));
        this.healthRegeneration = new Attribute<Byte>(info.healthRegenerationPerSecond());
        this.vision = new Attribute<Integer>(info.vision());
    }

    public void addXP(int deltaXP) {
        this.getExperience().modifyBaseValue(new AttributeModifier(Modification.ADD, deltaXP));
        if (this.getExperience().getCurrentValue() >= this.getExperience().getMaxValue()) {
            this.levelUp();
        }
    }

    public Attribute<Float> getAttackSpeed() {
        return this.attackSpeed;
    }

    public Attribute<Float> getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public RangeAttribute<Integer> getExperience() {
        return this.experience;
    }

    public RangeAttribute<Integer> getHealth() {
        return this.health;
    }

    public Attribute<Byte> getHealthRegeneration() {
        return this.healthRegeneration;
    }

    public RangeAttribute<Byte> getLevel() {
        return this.level;
    }

    public RangeAttribute<Short> getShield() {
        return this.shield;
    }

    public Attribute<Float> getVelocity() {
        return this.velocity;
    }

    public Attribute<Integer> getVision() {
        return this.vision;
    }

    public void levelUp() {
        if (this.getLevel().getCurrentValue() >= this.getLevel().getMaxValue()) {
            return;
        }
        this.getLevel().modifyBaseValue(new AttributeModifier(Modification.ADD, 1.0));
        this.getExperience().modifyBaseValue(new AttributeModifier(Modification.SET, 0.0));
        this.updateAttributes();
        for (Consumer<CombatAttributes> consumer : this.levelUpConsumer) {
            consumer.accept(this);
        }
    }

    public void onLevelUp(Consumer<CombatAttributes> consumer) {
        if (!this.levelUpConsumer.contains(consumer)) {
            this.levelUpConsumer.add(consumer);
        }
    }

    protected void updateAttributes() {
        float maxXp = (float)((double)this.info.maxExperience() * Math.sqrt(this.getLevel().getCurrentValue().byteValue()));
        this.getHealth().modifyMaxBaseValue(new AttributeModifier(Modification.MULTIPLY, 1.1f));
        this.getExperience().modifyMaxBaseValue(new AttributeModifier(Modification.SET, maxXp));
        this.getShield().modifyMaxBaseValue(new AttributeModifier(Modification.MULTIPLY, 1.1f));
        this.getHealthRegeneration().modifyBaseValue(new AttributeModifier(Modification.MULTIPLY, 1.1f));
        this.getDamageMultiplier().modifyBaseValue(new AttributeModifier(Modification.MULTIPLY, 1.1f));
    }
}

