/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.entities;

import de.gurkenlabs.litiengine.Align;
import de.gurkenlabs.litiengine.Valign;
import de.gurkenlabs.litiengine.annotation.CollisionInfo;
import de.gurkenlabs.litiengine.entities.Entity;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.environment.tilemap.TmxProperty;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

@CollisionInfo(collision=true)
public abstract class CollisionEntity
extends Entity
implements ICollisionEntity {
    private static final double HEIGHT_FACTOR = 0.4;
    private static final double WIDTH_FACTOR = 0.4;
    @TmxProperty(name="collisionAlign")
    private Align align = Align.CENTER;
    @TmxProperty(name="collision")
    private boolean collision;
    @TmxProperty(name="collisionboxHeightFactor")
    private float collisionBoxHeight;
    @TmxProperty(name="collisionboxWidthFactor")
    private float collisionBoxWidth;
    @TmxProperty(name="collisionValign")
    private Valign valign = Valign.DOWN;
    private Rectangle2D collisionBox;

    protected CollisionEntity() {
        CollisionInfo info = this.getClass().getAnnotation(CollisionInfo.class);
        this.collisionBoxWidth = info.collisionBoxWidth();
        this.collisionBoxHeight = info.collisionBoxHeight();
        this.collision = info.collision();
        this.setCollisionBoxValign(info.valign());
        this.setCollisionBoxAlign(info.align());
        this.collisionBox = this.getCollisionBox(this.getLocation());
    }

    public static Rectangle2D getCollisionBox(Point2D location, double entityWidth, double entityHeight, double collisionBoxWidth, double collisionBoxHeight, Align align, Valign valign) {
        double x = location.getX() + align.getLocation(entityWidth, collisionBoxWidth);
        double y = location.getY() + valign.getLocation(entityHeight, collisionBoxHeight);
        return new Rectangle2D.Double(x, y, collisionBoxWidth, collisionBoxHeight);
    }

    @Override
    public boolean canCollideWith(ICollisionEntity otherEntity) {
        return true;
    }

    @Override
    public Align getCollisionBoxAlign() {
        return this.align;
    }

    @Override
    public Rectangle2D getCollisionBox() {
        return this.collisionBox;
    }

    @Override
    public Rectangle2D getCollisionBox(Point2D location) {
        double newCollisionBoxWidth = this.getCollisionBoxWidth() != -1.0f ? (double)this.getCollisionBoxWidth() : (double)this.getWidth() * 0.4;
        double newCollisionBoxHeight = this.getCollisionBoxHeight() != -1.0f ? (double)this.getCollisionBoxHeight() : (double)this.getHeight() * 0.4;
        return CollisionEntity.getCollisionBox(location, this.getWidth(), this.getHeight(), newCollisionBoxWidth, newCollisionBoxHeight, this.getCollisionBoxAlign(), this.getCollisionBoxValign());
    }

    @Override
    public float getCollisionBoxHeight() {
        return this.collisionBoxHeight;
    }

    @Override
    public float getCollisionBoxWidth() {
        return this.collisionBoxWidth;
    }

    @Override
    public Point2D getCollisionBoxCenter() {
        return new Point2D.Double(this.getCollisionBox().getCenterX(), this.getCollisionBox().getCenterY());
    }

    @Override
    public Valign getCollisionBoxValign() {
        return this.valign;
    }

    @Override
    public boolean hasCollision() {
        return this.collision;
    }

    @Override
    public void setCollision(boolean collision) {
        this.collision = collision;
    }

    @Override
    public void setCollisionBoxAlign(Align align) {
        this.align = align;
        this.collisionBox = this.getCollisionBox(this.getLocation());
    }

    @Override
    public void setCollisionBoxHeight(float collisionBoxHeight) {
        this.collisionBoxHeight = collisionBoxHeight;
        this.collisionBox = this.getCollisionBox(this.getLocation());
    }

    @Override
    public void setCollisionBoxValign(Valign valign) {
        this.valign = valign;
        this.collisionBox = this.getCollisionBox(this.getLocation());
    }

    @Override
    public void setCollisionBoxWidth(float collisionBoxWidth) {
        this.collisionBoxWidth = collisionBoxWidth;
        this.collisionBox = this.getCollisionBox(this.getLocation());
    }

    @Override
    public void setLocation(Point2D location) {
        super.setLocation(location);
        this.collisionBox = this.getCollisionBox(this.getLocation());
    }

    @Override
    public void setSize(float width, float height) {
        super.setSize(width, height);
        this.collisionBox = this.getCollisionBox(this.getLocation());
    }

    @Override
    public void setHeight(float height) {
        super.setHeight(height);
        this.collisionBox = this.getCollisionBox(this.getLocation());
    }

    @Override
    public void setWidth(float width) {
        super.setWidth(width);
        this.collisionBox = this.getCollisionBox(this.getLocation());
    }
}

