/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.attributes;

import de.gurkenlabs.litiengine.attributes.AttributeModifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Attribute<T extends Number> {
    private final List<AttributeModifier<T>> modifiers = new ArrayList<AttributeModifier<T>>();
    private T baseValue;

    public Attribute(T initialValue) {
        this.baseValue = initialValue;
    }

    public void addModifier(AttributeModifier<T> modifier) {
        if (this.getModifiers().contains(modifier)) {
            return;
        }
        this.getModifiers().add(modifier);
        Collections.sort(this.getModifiers());
    }

    public T getCurrentValue() {
        return this.applyModifiers(this.getBaseValue());
    }

    public List<AttributeModifier<T>> getModifiers() {
        return this.modifiers;
    }

    public boolean isModifierApplied(AttributeModifier<T> modifier) {
        return this.getModifiers().contains(modifier);
    }

    public void modifyBaseValue(AttributeModifier<T> modifier) {
        this.baseValue = modifier.modify(this.getBaseValue());
    }

    public void removeModifier(AttributeModifier<T> modifier) {
        this.getModifiers().remove(modifier);
        Collections.sort(this.getModifiers());
    }

    public void setBaseValue(T baseValue) {
        this.baseValue = baseValue;
    }

    protected T applyModifiers(T baseValue) {
        if (this.getModifiers().isEmpty()) {
            return baseValue;
        }
        T currentValue = baseValue;
        for (AttributeModifier<T> modifier : this.getModifiers()) {
            currentValue = modifier.modify(currentValue);
        }
        return currentValue;
    }

    protected T getBaseValue() {
        return this.baseValue;
    }
}

