/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.abilities;

import de.gurkenlabs.litiengine.abilities.Ability;
import de.gurkenlabs.litiengine.abilities.effects.EntityHitArgument;
import de.gurkenlabs.litiengine.entities.Creature;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public abstract class OffensiveAbility
extends Ability {
    private final List<Consumer<EntityHitArgument>> entityHitConsumers = new CopyOnWriteArrayList<Consumer<EntityHitArgument>>();

    protected OffensiveAbility(Creature executingEntity) {
        super(executingEntity);
    }

    public void entityHit(EntityHitArgument arg) {
        for (Consumer<EntityHitArgument> consumer : this.entityHitConsumers) {
            consumer.accept(arg);
        }
    }

    public int getAttackDamage() {
        return Math.round((float)this.getAttributes().getValue().getCurrentValue().intValue() * this.getExecutor().getAttributes().getDamageMultiplier().getCurrentValue().floatValue());
    }

    public void onEntityHit(Consumer<EntityHitArgument> consumer) {
        if (!this.entityHitConsumers.contains(consumer)) {
            this.entityHitConsumers.add(consumer);
        }
    }
}

