/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.graphics.ImageCache;
import de.gurkenlabs.litiengine.util.ImageProcessing;
import de.gurkenlabs.litiengine.util.io.FileUtilities;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public final class Resources {
    private static final HashMap<String, Font> fonts = new HashMap();
    public static final String LOCALIZATION_RESOURCE_FOLDER = "localization/";
    public static final String DEFAULT_BUNDLE = "strings";
    public static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static final String ENCODING_UTF_8 = "UTF-8";
    private static String encoding = "ISO-8859-1";
    private static final Logger log = Logger.getLogger(Resources.class.getName());

    private Resources() {
    }

    public static void setEncoding(String newEncoding) {
        if (newEncoding == null || newEncoding.isEmpty()) {
            throw new IllegalArgumentException("The encoding must not be null or empty.");
        }
        encoding = newEncoding;
    }

    public static boolean contains(String key) {
        return Resources.contains(DEFAULT_BUNDLE, key);
    }

    public static boolean contains(String bundleName, String key) {
        try {
            ResourceBundle defaultBundle = ResourceBundle.getBundle(LOCALIZATION_RESOURCE_FOLDER + bundleName, Game.getConfiguration().client().getLocale());
            return defaultBundle.containsKey(key);
        }
        catch (MissingResourceException me) {
            StringWriter sw = new StringWriter();
            me.printStackTrace(new PrintWriter(sw));
            String stacktrace = sw.toString();
            log.severe(stacktrace);
            return false;
        }
    }

    public static String get(String key) {
        if (key == null) {
            return null;
        }
        return Resources.getFrom(DEFAULT_BUNDLE, key, new Object[0]);
    }

    public static String get(String key, Object ... args) {
        if (key == null) {
            return null;
        }
        return Resources.getFrom(DEFAULT_BUNDLE, key, args);
    }

    public static String getFrom(String bundleName, String key, Object ... args) {
        if (bundleName == null || key == null) {
            return null;
        }
        try {
            String decodedValue;
            ResourceBundle defaultBundle = ResourceBundle.getBundle(LOCALIZATION_RESOURCE_FOLDER + bundleName, Game.getConfiguration().client().getLocale());
            String value = defaultBundle.getString(key);
            String string = decodedValue = encoding.equals(ENCODING_ISO_8859_1) ? value : new String(value.getBytes(ENCODING_ISO_8859_1), encoding);
            if (args.length > 0) {
                return MessageFormat.format(decodedValue, args);
            }
            return decodedValue;
        }
        catch (UnsupportedEncodingException | MissingResourceException me) {
            StringWriter sw = new StringWriter();
            me.printStackTrace(new PrintWriter(sw));
            String stacktrace = sw.toString();
            log.severe(stacktrace);
            return key;
        }
    }

    public static BufferedImage getImage(String absolutPath) {
        return Resources.getImage(absolutPath, false);
    }

    public static BufferedImage getImage(String absolutPath, boolean forceLoad) {
        if (absolutPath == null || absolutPath.isEmpty()) {
            return null;
        }
        String cacheKey = Integer.toString(absolutPath.hashCode());
        if (!forceLoad && ImageCache.IMAGES.containsKey(cacheKey)) {
            return ImageCache.IMAGES.get(cacheKey);
        }
        BufferedImage img = null;
        InputStream imageFile = FileUtilities.getGameResource(absolutPath);
        if (imageFile != null) {
            try {
                img = ImageIO.read(imageFile);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }
        if (img == null) {
            return null;
        }
        BufferedImage compatibleImg = ImageProcessing.getCompatibleImage(img.getWidth(), img.getHeight());
        compatibleImg.createGraphics().drawImage((Image)img, 0, 0, null);
        ImageCache.IMAGES.put(cacheKey, compatibleImg);
        return compatibleImg;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getStringList(String textFile) {
        if (textFile == null) return new String[0];
        if (textFile.isEmpty()) {
            return new String[0];
        }
        try (InputStream is = FileUtilities.getGameResource(textFile);){
            if (is == null) {
                String[] stringArray2 = new String[]{};
                return stringArray2;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            ArrayList<String> strings = new ArrayList<String>();
            String str = "";
            while ((str = reader.readLine()) != null) {
                strings.add(str);
            }
            String[] stockArr = new String[strings.size()];
            String[] stringArray = strings.toArray(stockArr);
            return stringArray;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return new String[0];
        }
    }

    public static Font getFont(String fontName) {
        if (fonts.containsKey(fontName)) {
            return fonts.get(fontName);
        }
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            InputStream fontStream = FileUtilities.getGameResource(fontName);
            if (fontStream == null) {
                log.log(Level.SEVERE, "font {0} could not be loaded", fontName);
                return null;
            }
            Font font = Font.createFont(0, fontStream);
            ge.registerFont(font);
            fonts.put(fontName, font);
            return font;
        }
        catch (FontFormatException | IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return Font.getFont(fontName);
        }
    }

    static {
        Locale.setDefault(new Locale("en", "US"));
    }
}

