/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.graphics.IRenderable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;

public class GameMetrics
implements IUpdateable,
IRenderable {
    private static final int OFFSET_X = 5;
    private static final int OFFSET_Y = 12;
    private final List<Long> bytesReceived;
    private final List<Long> bytesSent;
    private long downStreamInBytes;
    private final List<Long> fps = new CopyOnWriteArrayList<Long>();
    private long framesPerSecond;
    private long lastNetworkTickTime;
    private int packagesReceived;
    private int packagesSent;
    private long ping;
    private long updatesPerSecond;
    private final List<Long> ups = new CopyOnWriteArrayList<Long>();
    private long upStreamInBytes;

    public GameMetrics() {
        this.bytesSent = new CopyOnWriteArrayList<Long>();
        this.bytesReceived = new CopyOnWriteArrayList<Long>();
    }

    public float getAverageFramesPerSecond() {
        if (this.fps.isEmpty()) {
            return 0.0f;
        }
        Optional opt = this.fps.stream().reduce((x, y) -> x + y);
        return opt.isPresent() ? (float)((Long)opt.get()).longValue() / (float)this.fps.size() : 0.0f;
    }

    public float getAverageUpdatesPerSecond() {
        if (this.ups.isEmpty()) {
            return 0.0f;
        }
        Optional opt = this.ups.stream().reduce((x, y) -> x + y);
        return opt.isPresent() ? (float)((Long)opt.get()).longValue() / (float)this.ups.size() : 0.0f;
    }

    public float getDownStreamInBytes() {
        return this.downStreamInBytes;
    }

    public long getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public int getPackagesReceived() {
        return this.packagesReceived;
    }

    public int getPackagesSent() {
        return this.packagesSent;
    }

    public long getPing() {
        return this.ping;
    }

    public long getUpdatesPerSecond() {
        return this.updatesPerSecond;
    }

    public float getUpStreamInBytes() {
        return this.upStreamInBytes;
    }

    public void packageReceived(long size) {
        this.bytesReceived.add(size);
    }

    public void packageSent(long size) {
        this.bytesSent.add(size);
    }

    public void recordNetworkTraffic() {
        Game.getLoop().attach(this);
    }

    @Override
    public void render(Graphics2D g) {
        int currentOffsetY = 12;
        g.setColor(Color.RED);
        g.setFont(new Font("SansSerif", 0, 10));
        Runtime runtime = Runtime.getRuntime();
        float usedMemory = (float)Math.round((float)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0f * 10.0f) * 0.1f;
        String memory = "memory: " + usedMemory + "MB";
        g.drawString(memory, 5, currentOffsetY);
        String pingText = "ping: " + this.getPing() + "ms";
        g.drawString(pingText, 5, currentOffsetY += 12);
        float upStream = (float)Math.round(Game.getMetrics().getUpStreamInBytes() / 1024.0f * 100.0f) * 0.01f;
        float downStream = (float)Math.round(Game.getMetrics().getDownStreamInBytes() / 1024.0f * 100.0f) * 0.01f;
        String in = "in: " + this.getPackagesReceived() + " - " + downStream + "kb/s";
        g.drawString(in, 5, currentOffsetY += 12);
        String out = "out: " + this.getPackagesSent() + " - " + upStream + "kb/s";
        g.drawString(out, 5, currentOffsetY += 12);
        String fpsString = "fps: " + this.getFramesPerSecond();
        g.drawString(fpsString, 5, currentOffsetY += 12);
        String upsString = "ups: " + this.getUpdatesPerSecond();
        g.drawString(upsString, 5, currentOffsetY += 12);
    }

    public void setFramesPerSecond(long currentFramesPerSecond) {
        this.framesPerSecond = currentFramesPerSecond;
        this.fps.add(this.framesPerSecond);
    }

    public void setPing(long ping) {
        this.ping = ping;
    }

    public void setUpdatesPerSecond(long updatesPerSecond) {
        this.updatesPerSecond = updatesPerSecond;
        this.ups.add(this.updatesPerSecond);
    }

    @Override
    public void update() {
        long currentMillis = System.currentTimeMillis();
        if (currentMillis - this.lastNetworkTickTime >= 1000L) {
            long sumDown;
            long sumUp;
            this.lastNetworkTickTime = currentMillis;
            Optional sentOpt = this.bytesSent.parallelStream().reduce((n1, n2) -> n1 + n2);
            this.upStreamInBytes = sumUp = !this.bytesSent.isEmpty() && sentOpt.isPresent() ? (Long)sentOpt.get() : 0L;
            this.packagesSent = this.bytesSent.size();
            Optional receivedOpt = this.bytesReceived.parallelStream().reduce((n1, n2) -> n1 + n2);
            this.downStreamInBytes = sumDown = !this.bytesReceived.isEmpty() && receivedOpt.isPresent() ? (Long)receivedOpt.get() : 0L;
            this.packagesReceived = this.bytesReceived.size();
            this.bytesSent.clear();
            this.bytesReceived.clear();
        }
    }
}

