/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine;

import de.gurkenlabs.litiengine.DefaultUncaughtExceptionHandler;
import de.gurkenlabs.litiengine.GameData;
import de.gurkenlabs.litiengine.GameInfo;
import de.gurkenlabs.litiengine.GameListener;
import de.gurkenlabs.litiengine.GameLoop;
import de.gurkenlabs.litiengine.GameMetrics;
import de.gurkenlabs.litiengine.GameTerminatedListener;
import de.gurkenlabs.litiengine.GameTime;
import de.gurkenlabs.litiengine.IGameLoop;
import de.gurkenlabs.litiengine.RenderLoop;
import de.gurkenlabs.litiengine.Resources;
import de.gurkenlabs.litiengine.SpriteSheetInfo;
import de.gurkenlabs.litiengine.configuration.ConfigurationGroup;
import de.gurkenlabs.litiengine.configuration.GameConfiguration;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.environment.EnvironmentLoadedListener;
import de.gurkenlabs.litiengine.environment.IEnvironment;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.environment.tilemap.ITileset;
import de.gurkenlabs.litiengine.graphics.Camera;
import de.gurkenlabs.litiengine.graphics.DebugRenderer;
import de.gurkenlabs.litiengine.graphics.ICamera;
import de.gurkenlabs.litiengine.graphics.RenderEngine;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.gui.screens.IScreenManager;
import de.gurkenlabs.litiengine.gui.screens.ScreenManager;
import de.gurkenlabs.litiengine.input.Input;
import de.gurkenlabs.litiengine.physics.IPhysicsEngine;
import de.gurkenlabs.litiengine.physics.PhysicsEngine;
import de.gurkenlabs.litiengine.sound.ISoundEngine;
import de.gurkenlabs.litiengine.sound.SoundEngine;
import de.gurkenlabs.litiengine.util.ArrayUtilities;
import de.gurkenlabs.litiengine.util.io.XmlUtilities;
import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public final class Game {
    public static final int EXIT_GAME_CLOSED = 0;
    public static final int EXIT_GAME_CRASHED = -1;
    public static final String COMMADLINE_ARG_RELEASE = "-release";
    public static final String COMMADLINE_ARG_NOGUI = "-nogui";
    protected static long environmentLoadTick;
    private static final Logger log;
    private static final String LOGGING_CONFIG_FILE = "logging.properties";
    private static boolean debug;
    private static boolean noGUIMode;
    private static final List<EnvironmentLoadedListener> environmentLoadedListeners;
    private static final List<GameListener> gameListeners;
    private static final List<GameTerminatedListener> gameTerminatedListeners;
    private static final GameConfiguration configuration;
    private static final RenderEngine graphicsEngine;
    private static final SoundEngine soundEngine;
    private static final IPhysicsEngine physicsEngine;
    private static final List<IMap> maps;
    private static final List<ITileset> tilesets;
    private static final GameMetrics metrics;
    private static final GameTime gameTime;
    private static GameInfo gameInfo;
    private static IEnvironment environment;
    private static ICamera camera;
    private static IGameLoop gameLoop;
    private static RenderLoop renderLoop;
    private static IScreenManager screenManager;
    private static boolean hasStarted;
    private static boolean initialized;

    private Game() {
    }

    public static void addGameListener(GameListener listener) {
        gameListeners.add(listener);
        gameTerminatedListeners.add(listener);
    }

    public static void removeGameListener(GameListener listener) {
        gameListeners.remove(listener);
        gameTerminatedListeners.remove(listener);
    }

    public static void addGameTerminatedListener(GameTerminatedListener listener) {
        gameTerminatedListeners.add(listener);
    }

    public static void removeGameTerminatedListener(GameTerminatedListener listener) {
        gameTerminatedListeners.remove(listener);
    }

    public static void addEnvironmentLoadedListener(EnvironmentLoadedListener listener) {
        environmentLoadedListeners.add(listener);
    }

    public static void removeEnvironmentLoadedListener(EnvironmentLoadedListener listener) {
        environmentLoadedListeners.remove(listener);
    }

    public static void allowDebug(boolean allow) {
        debug = allow;
    }

    public static void hideGUI(boolean noGui) {
        noGUIMode = noGui;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static boolean isInNoGUIMode() {
        return noGUIMode;
    }

    public static GameConfiguration getConfiguration() {
        return configuration;
    }

    public static IEnvironment getEnvironment() {
        return environment;
    }

    public static GameInfo getInfo() {
        return gameInfo;
    }

    public static IGameLoop getLoop() {
        return gameLoop;
    }

    public static IMap getMap(String mapName) {
        if (mapName == null || mapName.isEmpty() || maps.isEmpty()) {
            return null;
        }
        for (IMap map : maps) {
            if (!map.getName().equals(mapName)) continue;
            return map;
        }
        return null;
    }

    public static List<IMap> getMaps() {
        return maps;
    }

    public static List<ITileset> getTilesets() {
        return tilesets;
    }

    public static GameMetrics getMetrics() {
        return metrics;
    }

    public static IPhysicsEngine getPhysicsEngine() {
        return physicsEngine;
    }

    public static RenderEngine getRenderEngine() {
        return graphicsEngine;
    }

    public static RenderLoop getRenderLoop() {
        return renderLoop;
    }

    public static IScreenManager getScreenManager() {
        return screenManager;
    }

    public static ISoundEngine getSoundEngine() {
        return soundEngine;
    }

    public static ICamera getCamera() {
        return camera;
    }

    public static GameTime getTime() {
        return gameTime;
    }

    public static boolean hasStarted() {
        return hasStarted;
    }

    public static void init(String ... args) {
        if (initialized) {
            log.log(Level.INFO, "The game has already been initialized.");
            return;
        }
        Game.handleCommandLineArguments(args);
        Game.getConfiguration().load();
        Locale.setDefault(new Locale(Game.getConfiguration().client().getCountry(), Game.getConfiguration().client().getLanguage()));
        GameLoop updateLoop = new GameLoop("Main Update Loop", Game.getConfiguration().client().getUpdaterate());
        updateLoop.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
        gameLoop = updateLoop;
        Game.getLoop().attach(Game.getPhysicsEngine());
        ScreenManager scrMgr = new ScreenManager(Game.getInfo().getTitle());
        renderLoop = new RenderLoop("Render Loop");
        renderLoop.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
        Thread.setDefaultUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler());
        screenManager = scrMgr;
        Game.getScreenManager().init(Game.getConfiguration().graphics().getResolutionWidth(), Game.getConfiguration().graphics().getResolutionHeight(), Game.getConfiguration().graphics().isFullscreen());
        Game.setCamera(new Camera());
        if (new File(LOGGING_CONFIG_FILE).exists()) {
            System.setProperty("java.util.logging.config.file", LOGGING_CONFIG_FILE);
            try {
                LogManager.getLogManager().readConfiguration();
            }
            catch (Exception e2) {
                log.log(Level.SEVERE, e2.getMessage(), e2);
            }
        }
        try {
            Input.init();
        }
        catch (AWTException e3) {
            log.log(Level.SEVERE, e3.getMessage(), e3);
        }
        if (!Game.isInNoGUIMode()) {
            if (Game.getConfiguration().client().showGameMetrics()) {
                Game.getScreenManager().getRenderComponent().onRendered(g -> Game.getMetrics().render((Graphics2D)g));
            }
            if (Game.getConfiguration().debug().isDebugEnabled()) {
                Game.getRenderEngine().onEntityRendered(e -> DebugRenderer.renderEntityDebugInfo(e.getGraphics(), (IEntity)e.getRenderedObject()));
            }
            Game.getScreenManager().getRenderComponent().onFpsChanged(fps -> Game.getMetrics().setFramesPerSecond(fps.intValue()));
            Game.getScreenManager().setIconImage(Resources.getImage("litiengine-icon.png"));
            Game.getScreenManager().getRenderComponent().addMouseListener(Input.mouse());
            Game.getScreenManager().getRenderComponent().addMouseMotionListener(Input.mouse());
            Game.getScreenManager().getRenderComponent().addMouseWheelListener(Input.mouse());
            Input.keyboard().onKeyTyped(154, key -> Game.getScreenManager().getRenderComponent().takeScreenshot());
        }
        Runtime.getRuntime().addShutdownHook(new Thread(Game::terminate, "Shutdown"));
        initialized = true;
    }

    /*
     * WARNING - void declaration
     */
    public static void load(String gameResourceFile) {
        void var5_11;
        GameData file = GameData.load(gameResourceFile);
        if (file == null) {
            return;
        }
        int mapCnt = 0;
        for (IMap iMap : file.getMaps()) {
            if (Game.getMaps().stream().anyMatch(x -> x.getName().equals(iMap.getName()))) continue;
            Game.getMaps().add(iMap);
            ++mapCnt;
        }
        log.log(Level.INFO, "{0} maps loaded from {1}", new Object[]{mapCnt, gameResourceFile});
        int tileCnt = 0;
        for (ITileset iTileset : file.getTilesets()) {
            if (Game.getTilesets().stream().anyMatch(x -> x.getName().equals(iTileset.getName()))) continue;
            Game.getTilesets().add(iTileset);
            ++tileCnt;
        }
        log.log(Level.INFO, "{0} tilesets loaded from {1}", new Object[]{tileCnt, gameResourceFile});
        ArrayList<Spritesheet> arrayList = new ArrayList<Spritesheet>();
        for (SpriteSheetInfo tileset : file.getSpriteSheets()) {
            Spritesheet sprite = Spritesheet.load(tileset);
            arrayList.add(sprite);
        }
        log.log(Level.INFO, "{0} spritesheets loaded from {1}", new Object[]{arrayList.size(), gameResourceFile});
        boolean bl = false;
        for (Spritesheet s : arrayList) {
            for (int i = 0; i < s.getRows() * s.getColumns(); ++i) {
                BufferedImage sprite = s.getSprite(i);
                if (sprite == null) continue;
                ++var5_11;
            }
        }
        log.log(Level.INFO, "{0} sprites loaded to memory", new Object[]{(int)var5_11});
    }

    public static void loadEnvironment(IEnvironment env) {
        if (Game.getEnvironment() != null) {
            Game.getEnvironment().unload();
        }
        environment = env;
        if (Game.getEnvironment() != null) {
            Game.getEnvironment().load();
        }
        for (EnvironmentLoadedListener listener : environmentLoadedListeners) {
            listener.environmentLoaded(Game.getEnvironment());
        }
        if (Game.getLoop() != null) {
            environmentLoadTick = Game.getLoop().getTicks();
        }
    }

    public static void start() {
        if (!initialized) {
            throw new IllegalStateException("The game cannot be started without being first initialized. Call Game.init(...) before Game.start().");
        }
        gameLoop.start();
        Input.start();
        soundEngine.start();
        if (!Game.isInNoGUIMode()) {
            renderLoop.start();
        }
        for (GameListener listener : gameListeners) {
            listener.started();
        }
        hasStarted = true;
    }

    private static void terminate() {
        for (GameListener gameListener : gameListeners) {
            if (gameListener.terminating()) continue;
            return;
        }
        Game.getConfiguration().save();
        Input.terminate();
        gameLoop.terminate();
        soundEngine.terminate();
        if (!Game.isInNoGUIMode()) {
            renderLoop.terminate();
        }
        for (GameTerminatedListener gameTerminatedListener : gameTerminatedListeners) {
            gameTerminatedListener.terminated();
        }
        hasStarted = false;
        initialized = false;
    }

    public static void setCamera(ICamera cam) {
        if (Game.getCamera() != null) {
            Game.getLoop().detach(camera);
        }
        camera = cam;
        if (!Game.isInNoGUIMode()) {
            Game.getLoop().attach(cam);
            Game.getCamera().updateFocus();
        }
    }

    public static void setInfo(GameInfo info) {
        gameInfo = info;
    }

    public static void setInfo(String gameInfoFile) {
        GameInfo info = XmlUtilities.readFromFile(GameInfo.class, gameInfoFile);
        if (info == null) {
            log.log(Level.WARNING, "Could not read game info from {0}", new Object[]{gameInfoFile});
        }
        Game.setInfo(info);
    }

    private static void handleCommandLineArguments(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        if (ArrayUtilities.containsArgument(args, COMMADLINE_ARG_RELEASE)) {
            Game.allowDebug(false);
        }
        if (ArrayUtilities.containsArgument(args, COMMADLINE_ARG_NOGUI)) {
            Game.hideGUI(true);
        }
    }

    static {
        log = Logger.getLogger(Game.class.getName());
        debug = true;
        noGUIMode = false;
        environmentLoadedListeners = new CopyOnWriteArrayList<EnvironmentLoadedListener>();
        gameListeners = new CopyOnWriteArrayList<GameListener>();
        gameTerminatedListeners = new CopyOnWriteArrayList<GameTerminatedListener>();
        graphicsEngine = new RenderEngine();
        physicsEngine = new PhysicsEngine();
        soundEngine = new SoundEngine();
        metrics = new GameMetrics();
        gameInfo = new GameInfo();
        maps = new CopyOnWriteArrayList<IMap>();
        tilesets = new CopyOnWriteArrayList<ITileset>();
        gameTime = new GameTime();
        configuration = new GameConfiguration(new ConfigurationGroup[0]);
    }
}

