/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public final class XmlUtilities {
    private static final Logger log = Logger.getLogger(XmlUtilities.class.getName());
    private static final Map<Class<?>, JAXBContext> jaxbContexts = new ConcurrentHashMap();

    private XmlUtilities() {
    }

    public static void saveWithCustomIndetation(ByteArrayInputStream input, FileOutputStream fos, int indentation) {
        try {
            Transformer transformer = SAXTransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("doctype-public", "yes");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indentation));
            SAXSource xmlSource = new SAXSource(new InputSource(input));
            StreamResult res = new StreamResult(fos);
            transformer.transform(xmlSource, res);
            fos.flush();
            fos.close();
        }
        catch (IOException | TransformerException | TransformerFactoryConfigurationError e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static <T> JAXBContext getContext(Class<T> cls) {
        try {
            JAXBContext jaxbContext;
            if (jaxbContexts.containsKey(cls)) {
                jaxbContext = jaxbContexts.get(cls);
            } else {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{cls});
                jaxbContexts.put(cls, jaxbContext);
            }
            return jaxbContext;
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static <T> T readFromFile(Class<T> cls, String path) {
        try {
            JAXBContext jaxbContext = XmlUtilities.getContext(cls);
            if (jaxbContext == null) {
                return null;
            }
            Unmarshaller um = jaxbContext.createUnmarshaller();
            InputStream stream = ClassLoader.getSystemResourceAsStream(path);
            if (stream == null) {
                stream = new FileInputStream(path);
            }
            return (T)um.unmarshal(stream);
        }
        catch (IOException | JAXBException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> String save(T object, String fileName, String extension) {
        if (fileName == null) return null;
        if (fileName.isEmpty()) {
            return null;
        }
        String fileNameWithExtension = fileName;
        if (!fileNameWithExtension.endsWith("." + extension)) {
            fileNameWithExtension = fileNameWithExtension + "." + extension;
        }
        File newFile = new File(fileNameWithExtension);
        try (FileOutputStream fileOut = new FileOutputStream(newFile);){
            JAXBContext jaxbContext = XmlUtilities.getContext(object.getClass());
            if (jaxbContext == null) {
                String string = null;
                return string;
            }
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)false);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            jaxbMarshaller.marshal(object, (OutputStream)out);
            out.flush();
            XmlUtilities.saveWithCustomIndetation(new ByteArrayInputStream(out.toByteArray()), fileOut, 1);
            out.close();
            jaxbMarshaller.marshal(object, (OutputStream)out);
            return newFile.toString();
        }
        catch (IOException | JAXBException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return newFile.toString();
    }
}

