/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class StreamUtilities {
    private static final Logger log = Logger.getLogger(StreamUtilities.class.getName());

    private StreamUtilities() {
    }

    public static void copy(File file, OutputStream out) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            StreamUtilities.copy((InputStream)in, out);
        }
    }

    public static void copy(InputStream in, File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            StreamUtilities.copy(in, (OutputStream)out);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int readCount;
        byte[] buffer = new byte[1024];
        while ((readCount = in.read(buffer)) >= 0) {
            out.write(buffer, 0, readCount);
        }
    }

    public static byte[] getByte(InputStream is) throws IOException {
        byte[] buf;
        int size = 1024;
        if (is instanceof ByteArrayInputStream) {
            size = is.available();
            buf = new byte[size];
            is.read(buf, 0, size);
        } else {
            int len;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            buf = new byte[size];
            while ((len = is.read(buf, 0, size)) != -1) {
                bos.write(buf, 0, len);
            }
            buf = bos.toByteArray();
        }
        return buf;
    }

    public static byte[] getBytes(InputStream in) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            StreamUtilities.copy(in, (OutputStream)buffer);
            return buffer.toByteArray();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return new byte[0];
        }
    }
}

