/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class FileUtilities {
    private static final Logger log = Logger.getLogger(FileUtilities.class.getName());
    private static final String[] DIR_BLACKLIST = new String[]{"\\bin", "\\screenshots"};

    private FileUtilities() {
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtilities.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        try {
            Files.delete(dir.toPath().toAbsolutePath());
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return false;
        }
        return true;
    }

    public static List<String> findFilesByExtension(List<String> fileNames, Path dir, String extension) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (path.toFile().isDirectory()) {
                    if (FileUtilities.isBlackListedDirectory(path)) continue;
                    FileUtilities.findFilesByExtension(fileNames, path, extension);
                    continue;
                }
                if (!path.toAbsolutePath().toString().endsWith(extension)) continue;
                fileNames.add(path.toAbsolutePath().toString());
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return fileNames;
    }

    public static List<String> findFiles(List<String> fileNames, Path dir, String ... files) {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (path.toFile().isDirectory()) {
                    if (FileUtilities.isBlackListedDirectory(path)) continue;
                    FileUtilities.findFiles(fileNames, path, files);
                    continue;
                }
                for (String file : files) {
                    if (!path.toAbsolutePath().toString().endsWith(file)) continue;
                    fileNames.add(path.toAbsolutePath().toString());
                }
            }
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return fileNames;
    }

    private static boolean isBlackListedDirectory(Path path) {
        for (String black : DIR_BLACKLIST) {
            if (!path.toAbsolutePath().toString().contains(black)) continue;
            return true;
        }
        return false;
    }

    public static String getExtension(File file) {
        return FileUtilities.getExtension(file.getAbsolutePath());
    }

    public static String getExtension(String fileName) {
        try {
            return fileName.substring(fileName.lastIndexOf(46) + 1);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getFileName(String path) {
        int lastBackslash;
        if (path == null || path.isEmpty()) {
            return "";
        }
        String name = path;
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        if ((lastBackslash = name.lastIndexOf(47)) != -1) {
            name = name.substring(lastBackslash + 1, name.length());
        } else {
            int lastForwardSlash = name.lastIndexOf(92);
            if (lastForwardSlash != -1) {
                name = name.substring(lastForwardSlash + 1, name.length());
            }
        }
        return name;
    }

    public static InputStream getGameResource(String file) {
        try {
            InputStream resourceStream = ClassLoader.getSystemResourceAsStream(file);
            if (resourceStream != null) {
                return new BufferedInputStream(resourceStream);
            }
            resourceStream = FileUtilities.class.getResourceAsStream(file);
            if (resourceStream != null) {
                return new BufferedInputStream(resourceStream);
            }
            File f = new File(file);
            if (f.exists()) {
                resourceStream = new FileInputStream(file);
                return new BufferedInputStream(resourceStream);
            }
            log.log(Level.INFO, "{0} could not be found.", file);
            return null;
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    public static String getParentDirPath(String fileOrDirPath) {
        if (fileOrDirPath.contains(File.separator)) {
            return fileOrDirPath.substring(0, fileOrDirPath.lastIndexOf(File.separatorChar) + 1);
        }
        if (fileOrDirPath.contains("/")) {
            return fileOrDirPath.substring(0, fileOrDirPath.lastIndexOf(47) + 1);
        }
        return "";
    }
}

