/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util.io;

import de.gurkenlabs.litiengine.util.io.StreamUtilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class CompressionUtilities {
    private static final Logger log = Logger.getLogger(CompressionUtilities.class.getName());

    private CompressionUtilities() {
    }

    public static byte[] compress(byte[] data) {
        Deflater deflater = new Deflater();
        deflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        deflater.finish();
        byte[] buffer = new byte[1024];
        try {
            while (!deflater.finished()) {
                int count = deflater.deflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return outputStream.toByteArray();
    }

    public static byte[] decompress(byte[] data) {
        Inflater inflater = new Inflater();
        inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        try {
            while (!inflater.finished()) {
                int count = inflater.inflate(buffer);
                outputStream.write(buffer, 0, count);
            }
            outputStream.close();
        }
        catch (IOException | DataFormatException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return outputStream.toByteArray();
    }

    public static void unzip(InputStream zipfile, File directory) throws IOException {
        ZipEntry entry;
        ZipInputStream zfile = new ZipInputStream(zipfile);
        while ((entry = zfile.getNextEntry()) != null) {
            File file = new File(directory, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
                continue;
            }
            file.getParentFile().mkdirs();
            try {
                StreamUtilities.copy((InputStream)zfile, file);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        zfile.close();
    }

    public static void zip(File directory, File zipfile) throws IOException {
        URI base = directory.toURI();
        LinkedList<File> queue = new LinkedList<File>();
        queue.push(directory);
        try (FileOutputStream out = new FileOutputStream(zipfile);){
            ZipOutputStream zout = new ZipOutputStream(out);
            while (!queue.isEmpty()) {
                directory = (File)queue.pop();
                for (File kid : directory.listFiles()) {
                    String name = base.relativize(kid.toURI()).getPath();
                    if (kid.isDirectory()) {
                        queue.push(kid);
                        name = name.endsWith("/") ? name : name + "/";
                        zout.putNextEntry(new ZipEntry(name));
                        continue;
                    }
                    zout.putNextEntry(new ZipEntry(name));
                    StreamUtilities.copy(kid, (OutputStream)zout);
                    zout.closeEntry();
                }
            }
        }
    }
}

