/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import de.gurkenlabs.litiengine.entities.Rotation;
import de.gurkenlabs.litiengine.graphics.ImageFormat;
import de.gurkenlabs.litiengine.graphics.Spritesheet;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class ImageProcessing {
    private static final Logger log = Logger.getLogger(ImageProcessing.class.getName());
    public static final int CROP_ALIGN_CENTER = 0;
    public static final int CROP_ALIGN_LEFT = 1;
    public static final int CROP_ALIGN_RIGHT = 2;
    public static final int CROP_VALIGN_BOTTOM = 3;
    public static final int CROP_VALIGN_CENTER = 0;
    public static final int CROP_VALIGN_TOP = 1;
    public static final int CROP_VALIGN_TOPCENTER = 2;

    private ImageProcessing() {
    }

    public static BufferedImage addShadow(BufferedImage image, int xOffset, int yOffset) {
        if (image == null) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        if (width == 0 || height == 0) {
            return image;
        }
        BufferedImage shadowImage = ImageProcessing.flashVisiblePixels(image, new Color(0, 0, 0, 30));
        if (shadowImage == null) {
            return image;
        }
        AffineTransform tx = new AffineTransform();
        tx.concatenate(AffineTransform.getScaleInstance(1.0, -0.15));
        tx.concatenate(AffineTransform.getTranslateInstance(0.0, -shadowImage.getHeight()));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        BufferedImage rotatedImage = op.filter(shadowImage, null);
        BufferedImage shadow = ImageProcessing.getCompatibleImage(width, height + rotatedImage.getHeight());
        Graphics2D g2D = shadow.createGraphics();
        g2D.drawImage((Image)rotatedImage, xOffset, yOffset, null);
        g2D.drawImage((Image)image, 0, 0, null);
        g2D.dispose();
        return shadow;
    }

    public static Image applyAlphaChannel(Image img, final Color color) {
        if (color == null || img == null) {
            return img;
        }
        RGBImageFilter filter = new RGBImageFilter(){
            public final int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(img.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    public static BufferedImage borderAlpha(BufferedImage image, Color strokeColor, boolean borderOnly) {
        BufferedImage bimage = ImageProcessing.getCompatibleImage(image.getWidth(null) + 2, image.getHeight(null) + 2);
        if (bimage == null) {
            return image;
        }
        BufferedImage strokeImg = ImageProcessing.flashVisiblePixels(image, strokeColor);
        Graphics2D graphics = bimage.createGraphics();
        graphics.drawImage((Image)strokeImg, 0, 1, null);
        graphics.drawImage((Image)strokeImg, 2, 1, null);
        graphics.drawImage((Image)strokeImg, 1, 0, null);
        graphics.drawImage((Image)strokeImg, 1, 2, null);
        Composite old = graphics.getComposite();
        graphics.setComposite(AlphaComposite.Clear);
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = image.getRGB(x, y);
                if (pixel >> 24 == 0) continue;
                graphics.fillRect(x + 1, y + 1, 1, 1);
            }
        }
        if (!borderOnly) {
            graphics.setComposite(old);
            graphics.drawImage((Image)image, 1, 1, null);
        }
        graphics.dispose();
        return bimage;
    }

    public static boolean isEmpty(BufferedImage image) {
        for (int y = 0; y < image.getHeight(); ++y) {
            for (int x = 0; x < image.getWidth(); ++x) {
                int pixel = image.getRGB(x, y);
                if (pixel >> 24 == 0) continue;
                return false;
            }
        }
        return true;
    }

    public static BufferedImage crop(BufferedImage image, int cropAlignment, int cropVerticlaAlignment, int width, int height) {
        int y;
        int x;
        if (width > image.getWidth() || height > image.getHeight()) {
            return image;
        }
        switch (cropAlignment) {
            case 0: {
                x = image.getWidth() / 2 - width / 2;
                break;
            }
            case 2: {
                x = image.getWidth() - width;
                break;
            }
            default: {
                x = 0;
            }
        }
        switch (cropVerticlaAlignment) {
            case 0: {
                y = image.getHeight() / 2 - height / 2;
                break;
            }
            case 3: {
                y = image.getHeight() - height;
                break;
            }
            case 2: {
                y = image.getHeight() / 2 - height;
                break;
            }
            default: {
                y = 0;
            }
        }
        return image.getSubimage(x, y, width, height);
    }

    public static BufferedImage decodeToImage(String imageString) {
        if (imageString == null) {
            return null;
        }
        BufferedImage image = null;
        try {
            byte[] imageByte = Base64.getDecoder().decode(imageString);
            ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);
            image = ImageIO.read(bis);
            bis.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return image;
    }

    public static String encodeToString(BufferedImage image) {
        return ImageProcessing.encodeToString(image, ImageFormat.PNG);
    }

    public static String encodeToString(BufferedImage image, ImageFormat imageFormat) {
        if (image == null) {
            return null;
        }
        String imageString = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, imageFormat != ImageFormat.UNDEFINED ? imageFormat.toString() : ImageFormat.PNG.toString(), bos);
            byte[] imageBytes = bos.toByteArray();
            imageString = Base64.getEncoder().encodeToString(imageBytes);
            bos.close();
        }
        catch (IOException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return imageString;
    }

    public static BufferedImage flashVisiblePixels(Image image, Color flashColor) {
        BufferedImage bimage = ImageProcessing.getCompatibleImage(image.getWidth(null), image.getHeight(null));
        if (bimage == null) {
            return null;
        }
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        for (int y = 0; y < bimage.getHeight(); ++y) {
            for (int x = 0; x < bimage.getWidth(); ++x) {
                int pixel = bimage.getRGB(x, y);
                if (pixel >> 24 == 0) continue;
                bimage.setRGB(x, y, flashColor.getRGB());
            }
        }
        return bimage;
    }

    public static BufferedImage flipSpritesHorizontally(Spritesheet sprite) {
        BufferedImage flippedSprite = ImageProcessing.getCompatibleImage(sprite.getSpriteWidth() * sprite.getTotalNumberOfSprites(), sprite.getSpriteHeight());
        if (flippedSprite == null) {
            return null;
        }
        Graphics2D g = (Graphics2D)flippedSprite.getGraphics();
        for (int i = 0; i < sprite.getTotalNumberOfSprites(); ++i) {
            g.drawImage((Image)ImageProcessing.horizontalFlip(sprite.getSprite(i)), i * sprite.getSpriteWidth(), 0, null);
        }
        g.dispose();
        return flippedSprite;
    }

    public static BufferedImage getCompatibleImage(int width, int height) {
        if (width == 0 && height == 0) {
            return null;
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice device = env.getDefaultScreenDevice();
        GraphicsConfiguration config = device.getDefaultConfiguration();
        return config.createCompatibleImage(width, height, 3);
    }

    public static BufferedImage[][] getSubImages(BufferedImage image, int rows, int columns) {
        BufferedImage[][] smallImages = new BufferedImage[rows][columns];
        int smallWidth = image.getWidth() / columns;
        int smallHeight = image.getHeight() / rows;
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                int cellX = x * smallWidth;
                int cellY = y * smallHeight;
                smallImages[y][x] = image.getSubimage(cellX, cellY, smallWidth, smallHeight);
            }
        }
        return smallImages;
    }

    public static BufferedImage horizontalFlip(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        if (w == 0 || h == 0) {
            return img;
        }
        BufferedImage dimg = ImageProcessing.getCompatibleImage(w, h);
        Graphics2D g = dimg.createGraphics();
        g.drawImage(img, 0, 0, w, h, w, 0, 0, h, null);
        g.dispose();
        return dimg;
    }

    public static boolean needsBorder(BufferedImage image, int x, int y) {
        if (y < 0 || y >= image.getHeight()) {
            return false;
        }
        if (x < 0 || x >= image.getWidth()) {
            return false;
        }
        if (image.getRGB(x, y) >> 24 != 0) {
            return false;
        }
        if (y > 0 && image.getRGB(x, y - 1) >> 24 != 0) {
            return true;
        }
        if (y < image.getHeight() - 1 && image.getRGB(x, y + 1) >> 24 != 0) {
            return true;
        }
        if (x > 0 && image.getRGB(x - 1, y) >> 24 != 0) {
            return true;
        }
        return x < image.getWidth() - 1 && image.getRGB(x + 1, y) >> 24 != 0;
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, Rotation rotation) {
        return ImageProcessing.rotate(bufferedImage, rotation.getRadians());
    }

    public static BufferedImage rotate(BufferedImage bufferedImage, double radians) {
        AffineTransform tx = new AffineTransform();
        tx.rotate(radians, (double)bufferedImage.getWidth() / 2.0, (double)bufferedImage.getHeight() / 2.0);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(bufferedImage, null);
    }

    public static BufferedImage scaleImage(BufferedImage image, int max) {
        Dimension2D newDimension = GeometricUtilities.scaleWithRatio(image.getWidth(), image.getHeight(), max);
        return ImageProcessing.scaleImage(image, (int)newDimension.getWidth(), (int)newDimension.getHeight());
    }

    public static BufferedImage scaleImage(BufferedImage image, float factor) {
        double width = image.getWidth();
        double height = image.getHeight();
        return ImageProcessing.scaleImage(image, (int)(width * (double)factor), (int)(height * (double)factor));
    }

    public static BufferedImage scaleImage(BufferedImage image, int width, int height) {
        return ImageProcessing.scaleImage(image, width, height, false);
    }

    public static BufferedImage scaleImage(BufferedImage image, int width, int height, boolean keepRatio) {
        return ImageProcessing.scaleImage(image, width, height, keepRatio, true);
    }

    public static BufferedImage scaleImage(BufferedImage image, int width, int height, boolean keepRatio, boolean fill) {
        if (width == 0 || height == 0 || image == null) {
            return null;
        }
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        double newWidth = width;
        double newHeight = height;
        if (keepRatio) {
            double ratioWidth = (double)image.getWidth() / (double)image.getHeight();
            double ratioHeight = (double)image.getHeight() / (double)image.getWidth();
            newHeight = newWidth * ratioHeight;
            if (newHeight > (double)height) {
                newHeight = height;
                newWidth = newHeight * ratioWidth;
            }
        }
        double scaleX = newWidth / (double)imageWidth;
        double scaleY = newHeight / (double)imageHeight;
        AffineTransform scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        AffineTransformOp bilinearScaleOp = new AffineTransformOp(scaleTransform, 1);
        BufferedImage scaled = bilinearScaleOp.filter(image, ImageProcessing.getCompatibleImage((int)newWidth, (int)newHeight));
        BufferedImage newImg = ImageProcessing.getCompatibleImage((int)newWidth, (int)newHeight);
        if (newImg == null) {
            return image;
        }
        Graphics2D g = (Graphics2D)newImg.getGraphics();
        g.drawImage((Image)scaled, 0, 0, null);
        g.dispose();
        if (fill && (newWidth != (double)width || newHeight != (double)height)) {
            BufferedImage wrapperImage = ImageProcessing.getCompatibleImage(width, height);
            Graphics2D g2 = (Graphics2D)wrapperImage.getGraphics();
            g2.drawImage((Image)newImg, (int)(((double)width - newWidth) / 2.0), (int)(((double)height - newHeight) / 2.0), null);
            g2.dispose();
            return wrapperImage;
        }
        return newImg;
    }

    public static BufferedImage scaleImageWidth(BufferedImage image, int newWidth) {
        double width = image.getWidth();
        double height = image.getHeight();
        if (width == 0.0 || height == 0.0) {
            return null;
        }
        double ratio = (double)newWidth / width;
        double newHeight = height * ratio;
        return ImageProcessing.scaleImage(image, newWidth, (int)newHeight);
    }

    public static BufferedImage setOpacity(Image img, float opacity) {
        BufferedImage bimage = ImageProcessing.getCompatibleImage(img.getWidth(null), img.getHeight(null));
        if (bimage == null) {
            return null;
        }
        Graphics2D g2d = bimage.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, opacity));
        g2d.drawImage(img, 0, 0, null);
        g2d.dispose();
        return bimage;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img == null) {
            return null;
        }
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = ImageProcessing.getCompatibleImage(img.getWidth(null), img.getHeight(null));
        if (bimage == null) {
            return null;
        }
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage verticalFlip(BufferedImage img) {
        int w = img.getWidth();
        int h = img.getHeight();
        if (w == 0 || h == 0) {
            return img;
        }
        BufferedImage dimg = ImageProcessing.getCompatibleImage(w, h);
        Graphics2D g = dimg.createGraphics();
        g.drawImage(img, 0, 0 + h, w, -h, null);
        g.dispose();
        return dimg;
    }

    public static BufferedImage zoom(BufferedImage image, float zoomLevel) {
        int newImageHeight;
        int newImageWidth = (int)((float)image.getWidth() * zoomLevel);
        BufferedImage resizedImage = ImageProcessing.getCompatibleImage(newImageWidth, newImageHeight = (int)((float)image.getHeight() * zoomLevel));
        if (resizedImage == null) {
            return image;
        }
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(image, 0, 0, newImageWidth, newImageHeight, null);
        g.dispose();
        return resizedImage;
    }
}

