/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.util;

import de.gurkenlabs.litiengine.util.ICommandListener;
import de.gurkenlabs.litiengine.util.ICommandManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsoleCommandListener
extends Thread
implements ICommandListener {
    private static final Logger log = Logger.getLogger(ConsoleCommandListener.class.getName());
    private final List<ICommandManager> commandManagers = new ArrayList<ICommandManager>();
    private boolean gameIsRunning = true;

    public ConsoleCommandListener(ICommandManager ... commandManagers) {
        if (commandManagers != null && commandManagers.length > 0) {
            for (ICommandManager manager : commandManagers) {
                if (this.commandManagers.contains(manager)) continue;
                this.commandManagers.add(manager);
            }
        }
    }

    @Override
    public void register(ICommandManager manager) {
        if (!this.commandManagers.contains(manager)) {
            this.commandManagers.add(manager);
        }
    }

    @Override
    public void run() {
        while (this.gameIsRunning) {
            BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));
            try {
                String s = bufferRead.readLine();
                this.commandManagers.forEach(manager -> manager.executeCommand(s));
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                this.interrupt();
            }
        }
    }

    @Override
    public void terminate() {
        this.gameIsRunning = false;
    }
}

