/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.sound;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.sound.ISoundPlayback;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.util.MathUtilities;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public final class SoundPlayback
implements Runnable,
ISoundPlayback {
    private static final Logger log = Logger.getLogger(SoundPlayback.class.getName());
    private static final ExecutorService executorServie;
    protected static final SourceDataLineCloseQueue closeQueue;
    private final List<Consumer<Sound>> finishedConsumer = new CopyOnWriteArrayList<Consumer<Sound>>();
    private final List<Consumer<Sound>> cancelledConsumer = new CopyOnWriteArrayList<Consumer<Sound>>();
    private final Point2D initialListenerLocation;
    private SourceDataLine dataLine;
    private IEntity entity;
    private float gain;
    private FloatControl gainControl;
    private FloatControl panControl;
    private Point2D location;
    private final Sound sound;
    private boolean playing;
    private boolean loop;
    private boolean cancelled;
    private boolean paused;

    protected SoundPlayback(Sound sound) {
        this(sound, null);
    }

    protected SoundPlayback(Sound sound, Point2D listenerLocation) {
        this.sound = sound;
        this.initialListenerLocation = listenerLocation;
    }

    protected SoundPlayback(Sound sound, Point2D listenerLocation, IEntity sourceEntity) {
        this(sound, listenerLocation);
        this.entity = sourceEntity;
    }

    protected SoundPlayback(Sound sound, Point2D listenerLocation, Point2D location) {
        this(sound, listenerLocation);
        this.location = location;
    }

    @Override
    public void run() {
        this.playing = true;
        this.loadDataLine();
        if (this.dataLine == null) {
            return;
        }
        this.initControls();
        this.initGain();
        this.updateControls(this.initialListenerLocation);
        this.dataLine.start();
        byte[] buffer = new byte[1024];
        ByteArrayInputStream str = new ByteArrayInputStream(this.sound.getStreamData());
        while (!this.cancelled) {
            while (this.isPaused() && this.isPlaying() && !this.cancelled) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            try {
                int readCount = str.read(buffer);
                if (readCount < 0) {
                    if (!this.loop || this.dataLine == null) break;
                    this.restartDataLine();
                    str = new ByteArrayInputStream(this.sound.getStreamData());
                    continue;
                }
                if (this.dataLine == null) continue;
                this.dataLine.write(buffer, 0, readCount);
            }
            catch (IOException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (this.dataLine != null) {
            this.dataLine.drain();
        }
        this.playing = false;
        for (Consumer<Sound> cons : this.finishedConsumer) {
            cons.accept(this.getSound());
        }
    }

    @Override
    public void onFinished(Consumer<Sound> cons) {
        this.finishedConsumer.add(cons);
    }

    @Override
    public void onCancelled(Consumer<Sound> cons) {
        this.cancelledConsumer.add(cons);
    }

    @Override
    public void cancel() {
        this.cancelled = true;
        for (Consumer<Sound> cons : this.cancelledConsumer) {
            cons.accept(this.getSound());
        }
    }

    @Override
    public void pausePlayback() {
        this.paused = true;
    }

    @Override
    public void resumePlayback() {
        this.paused = false;
    }

    @Override
    public boolean isPaused() {
        return this.paused;
    }

    protected static void terminate() {
        closeQueue.terminate();
    }

    protected void dispose() {
        if (this.isPlaying()) {
            this.cancel();
        }
        if (this.dataLine != null) {
            closeQueue.enqueue(this.dataLine);
            this.dataLine = null;
            this.gainControl = null;
            this.panControl = null;
        }
    }

    protected Sound getSound() {
        return this.sound;
    }

    protected boolean isPlaying() {
        return this.playing;
    }

    protected void play() {
        this.play(false, null, -1.0f);
    }

    protected void play(boolean loop, float volume) {
        this.play(loop, null, volume);
    }

    protected void play(boolean loop, Point2D location, float gain) {
        if (this.dataLine != null) {
            return;
        }
        this.gain = gain;
        this.location = location;
        this.loop = loop;
        executorServie.execute(this);
    }

    protected void setGain(float g) {
        if (this.gainControl == null) {
            return;
        }
        float newGain = MathUtilities.clamp(g, 0.0f, 1.0f);
        double minimumDB = this.gainControl.getMinimum();
        double maximumDB = 1.0;
        double ampGainDB = 0.5 - minimumDB;
        double cste = Math.log(10.0) / 20.0;
        float valueDB = (float)(minimumDB + 1.0 / cste * Math.log(1.0 + (Math.exp(cste * ampGainDB) - 1.0) * (double)newGain));
        this.gainControl.setValue(valueDB);
    }

    protected void updateControls(Point2D listenerLocation) {
        Point2D loc;
        if (listenerLocation == null) {
            return;
        }
        Point2D point2D = loc = this.entity != null ? this.entity.getLocation() : this.location;
        if (loc == null) {
            return;
        }
        this.setGain(SoundPlayback.calculateGain(loc, listenerLocation));
        this.setPan(SoundPlayback.calculatePan(loc, listenerLocation));
    }

    private static float calculateGain(Point2D currentLocation, Point2D listenerLocation) {
        if (currentLocation == null || listenerLocation == null) {
            return 0.0f;
        }
        float distanceFromListener = (float)currentLocation.distance(listenerLocation);
        float gain = distanceFromListener <= 0.0f ? 1.0f : (distanceFromListener >= Game.getSoundEngine().getMaxDistance() ? 0.0f : 1.0f - distanceFromListener / Game.getSoundEngine().getMaxDistance());
        gain = MathUtilities.clamp(gain, 0.0f, 1.0f);
        return gain *= Game.getConfiguration().sound().getSoundVolume();
    }

    private static float calculatePan(Point2D currentLocation, Point2D listenerLocation) {
        double angle = GeometricUtilities.calcRotationAngleInDegrees(listenerLocation, currentLocation);
        return (float)(-Math.sin(angle));
    }

    private void initGain() {
        float initialGain = this.gain > 0.0f ? this.gain : Game.getConfiguration().sound().getSoundVolume();
        this.setGain(initialGain);
    }

    private void loadDataLine() {
        DataLine.Info dataInfo = new DataLine.Info(SourceDataLine.class, this.sound.getFormat());
        try {
            this.dataLine = (SourceDataLine)AudioSystem.getLine(dataInfo);
            this.dataLine.open();
        }
        catch (LineUnavailableException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private void restartDataLine() {
        this.dataLine.drain();
        this.loadDataLine();
        this.initControls();
        this.initGain();
        this.dataLine.start();
    }

    private void initControls() {
        if (this.dataLine == null) {
            return;
        }
        try {
            this.panControl = !this.dataLine.isControlSupported(FloatControl.Type.PAN) ? null : (FloatControl)this.dataLine.getControl(FloatControl.Type.PAN);
        }
        catch (IllegalArgumentException iae) {
            this.panControl = null;
        }
        try {
            this.gainControl = !this.dataLine.isControlSupported(FloatControl.Type.MASTER_GAIN) ? null : (FloatControl)this.dataLine.getControl(FloatControl.Type.MASTER_GAIN);
        }
        catch (IllegalArgumentException iae) {
            this.gainControl = null;
        }
    }

    private void setPan(float p) {
        if (this.panControl == null) {
            return;
        }
        float pan = MathUtilities.clamp(p, -1.0f, 1.0f);
        this.panControl.setValue(pan);
    }

    static {
        closeQueue = new SourceDataLineCloseQueue();
        executorServie = Executors.newCachedThreadPool();
        executorServie.execute(closeQueue);
    }

    private static class SourceDataLineCloseQueue
    implements Runnable {
        private boolean isRunning = true;
        private final Queue<SourceDataLine> queue = new ConcurrentLinkedQueue<SourceDataLine>();

        private SourceDataLineCloseQueue() {
        }

        public void enqueue(SourceDataLine clip) {
            this.queue.add(clip);
        }

        @Override
        public void run() {
            while (this.isRunning) {
                this.closeAllSoundSources();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    this.terminate();
                    log.log(Level.SEVERE, e.getMessage(), e);
                    Thread.currentThread().interrupt();
                }
            }
            this.closeAllSoundSources();
        }

        public void terminate() {
            this.isRunning = false;
        }

        private void closeAllSoundSources() {
            if (this.queue.isEmpty()) {
                return;
            }
            while (this.queue.peek() != null) {
                SourceDataLine clip = this.queue.poll();
                clip.stop();
                clip.flush();
                clip.close();
            }
        }
    }
}

