/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.sound;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.IUpdateable;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.sound.ISoundEngine;
import de.gurkenlabs.litiengine.sound.ISoundPlayback;
import de.gurkenlabs.litiengine.sound.Sound;
import de.gurkenlabs.litiengine.sound.SoundPlayback;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public final class SoundEngine
implements ISoundEngine,
IUpdateable {
    private static final int DEFAULT_MAX_DISTANCE = 250;
    private Point2D listenerLocation;
    private Function<Point2D, Point2D> listenerLocationCallback;
    private float maxDist = 250.0f;
    private SoundPlayback music;
    private final List<SoundPlayback> sounds = new CopyOnWriteArrayList<SoundPlayback>();

    public SoundEngine() {
        this.setListenerLocationCallback(old -> Game.getCamera().getFocus());
    }

    @Override
    public float getMaxDistance() {
        return this.maxDist;
    }

    @Override
    public ISoundPlayback playMusic(Sound sound) {
        if (sound == null || this.music != null && sound.equals(this.music.getSound())) {
            return null;
        }
        if (this.music != null) {
            this.music.dispose();
        }
        this.music = new SoundPlayback(sound);
        this.music.play(true, Game.getConfiguration().sound().getMusicVolume());
        return this.music;
    }

    @Override
    public ISoundPlayback playSound(IEntity entity, Sound sound) {
        if (sound == null) {
            return null;
        }
        SoundPlayback playback = new SoundPlayback(sound, this.listenerLocation, entity);
        playback.play();
        this.sounds.add(playback);
        return playback;
    }

    @Override
    public ISoundPlayback playSound(Point2D location, Sound sound) {
        if (sound == null) {
            return null;
        }
        SoundPlayback playback = new SoundPlayback(sound, this.listenerLocation);
        playback.play();
        this.sounds.add(playback);
        return playback;
    }

    @Override
    public ISoundPlayback playSound(Sound sound) {
        if (sound == null) {
            return null;
        }
        SoundPlayback playback = new SoundPlayback(sound);
        playback.play();
        this.sounds.add(playback);
        return playback;
    }

    @Override
    public void setMaxDistance(float radius) {
        this.maxDist = radius;
    }

    @Override
    public void start() {
        Game.getLoop().attach(this);
        this.listenerLocation = Game.getCamera().getFocus();
    }

    @Override
    public void stopMusic() {
        if (this.music == null) {
            return;
        }
        this.music.dispose();
        this.music = null;
    }

    @Override
    public void terminate() {
        Game.getLoop().detach(this);
        if (this.music != null && this.music.isPlaying()) {
            this.music.dispose();
            this.music = null;
        }
        for (SoundPlayback playback : this.sounds) {
            playback.dispose();
        }
        this.sounds.clear();
        SoundPlayback.terminate();
    }

    @Override
    public void update() {
        this.listenerLocation = this.listenerLocationCallback.apply(this.listenerLocation);
        ArrayList<SoundPlayback> remove = new ArrayList<SoundPlayback>();
        for (SoundPlayback s : this.sounds) {
            if (s == null || s.isPlaying()) continue;
            s.dispose();
            remove.add(s);
        }
        this.sounds.removeAll(remove);
        for (SoundPlayback s : this.sounds) {
            s.updateControls(this.listenerLocation);
        }
        if (this.music != null) {
            this.music.setGain(Game.getConfiguration().sound().getMusicVolume());
        }
        if (this.music != null && !this.music.isPlaying()) {
            this.playMusic(this.music.getSound());
        }
    }

    @Override
    public void setListenerLocationCallback(Function<Point2D, Point2D> listenerLocationCallback) {
        this.listenerLocationCallback = listenerLocationCallback;
    }
}

