/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.sound;

import de.gurkenlabs.litiengine.util.io.FileUtilities;
import de.gurkenlabs.litiengine.util.io.StreamUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public final class Sound {
    private static final Map<String, Sound> sounds = new ConcurrentHashMap<String, Sound>();
    private static final Logger log = Logger.getLogger(Sound.class.getName());
    private AudioFormat format;
    private final String name;
    private AudioInputStream stream;
    private byte[] streamData;

    private Sound(InputStream is, String name) {
        this.name = name;
        try {
            AudioInputStream in = AudioSystem.getAudioInputStream(is);
            if (in != null) {
                AudioFormat baseFormat = in.getFormat();
                AudioFormat decodedFormat = this.getOutFormat(baseFormat);
                this.stream = in = AudioSystem.getAudioInputStream(decodedFormat, in);
                this.streamData = StreamUtilities.getBytes(this.stream);
                this.format = this.stream.getFormat();
            }
        }
        catch (IOException | UnsupportedAudioFileException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public static Sound find(String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        String fileName = FileUtilities.getFileName(name);
        if (!sounds.containsKey(fileName)) {
            log.log(Level.SEVERE, "Could not find sound {0} because it was not loaded..", new Object[]{name});
            return null;
        }
        return sounds.get(fileName);
    }

    public static Sound load(String path) {
        String fileName = FileUtilities.getFileName(path);
        Sound sound = sounds.get(fileName);
        if (sound != null) {
            return sound;
        }
        InputStream is = FileUtilities.getGameResource(path);
        if (is == null) {
            log.log(Level.SEVERE, "Could not load sound {0} because the game resource was not found.", new Object[]{path});
            return null;
        }
        sound = new Sound(is, fileName);
        sounds.put(fileName, sound);
        return sound;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getStreamData() {
        if (this.streamData == null) {
            return new byte[0];
        }
        return (byte[])this.streamData.clone();
    }

    private AudioFormat getOutFormat(AudioFormat inFormat) {
        int ch = inFormat.getChannels();
        float rate = inFormat.getSampleRate();
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, ch, ch * 2, rate, false);
    }
}

