/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.physics.pathfinding;

import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.physics.IPhysicsEngine;
import de.gurkenlabs.litiengine.physics.Path;
import de.gurkenlabs.litiengine.physics.pathfinding.AStarGrid;
import de.gurkenlabs.litiengine.physics.pathfinding.AStarNode;
import de.gurkenlabs.litiengine.physics.pathfinding.PathFinder;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;

public class AStarPathFinder
extends PathFinder {
    private final AStarGrid grid;

    public AStarPathFinder(IPhysicsEngine physicsEngine, IMap map) {
        this.grid = new AStarGrid(physicsEngine, map, map.getTileSize().width);
    }

    public AStarPathFinder(IPhysicsEngine physicsEngine, IMap map, int gridNodeSize) {
        this.grid = new AStarGrid(physicsEngine, map, gridNodeSize);
    }

    @Override
    public Path findPath(IMobileEntity entity, Point2D target) {
        AStarNode targetNode;
        Point2D.Double startLocation = new Point2D.Double(entity.getCollisionBox().getCenterX(), entity.getCollisionBox().getCenterY());
        if (!this.intersectsWithAnyCollisionBox(entity, startLocation, target)) {
            return this.findDirectPath(startLocation, target);
        }
        AStarNode startNode = this.getGrid().getNodeFromMapLocation(startLocation);
        if (startNode.equals(targetNode = this.getGrid().getNodeFromMapLocation(target))) {
            return null;
        }
        if (!targetNode.isWalkable()) {
            return this.findDirectPath(startLocation, target);
        }
        ArrayList<AStarNode> opened = new ArrayList<AStarNode>();
        ArrayList<AStarNode> closed = new ArrayList<AStarNode>();
        opened.add(startNode);
        while (!opened.isEmpty()) {
            AStarNode currentNode = (AStarNode)opened.get(0);
            for (int i = 1; i < opened.size(); ++i) {
                if (((AStarNode)opened.get(i)).getfCost() >= currentNode.getfCost() && (((AStarNode)opened.get(i)).getfCost() != currentNode.getfCost() || ((AStarNode)opened.get(i)).gethCost() >= currentNode.gethCost())) continue;
                currentNode = (AStarNode)opened.get(i);
            }
            opened.remove(currentNode);
            closed.add(currentNode);
            if (currentNode.equals(targetNode)) {
                return this.retracePath(startNode, targetNode);
            }
            for (AStarNode neighbour : this.grid.getNeighbours(currentNode)) {
                int newgCostOfNeighbour;
                if (!neighbour.equals(targetNode) && !neighbour.isWalkable() || closed.contains(neighbour) || (newgCostOfNeighbour = currentNode.getgCost() + currentNode.getCosts(neighbour)) >= neighbour.getgCost() && opened.contains(neighbour)) continue;
                neighbour.setgCost(newgCostOfNeighbour);
                neighbour.sethCost(neighbour.getCosts(targetNode));
                neighbour.setPredecessor(currentNode);
                if (opened.contains(neighbour)) continue;
                opened.add(neighbour);
            }
        }
        return null;
    }

    public AStarGrid getGrid() {
        return this.grid;
    }

    private Path retracePath(AStarNode startNode, AStarNode targetNode) {
        ArrayList<AStarNode> path = new ArrayList<AStarNode>();
        for (AStarNode currentNode = targetNode.getPredecessor(); currentNode != startNode; currentNode = currentNode.getPredecessor()) {
            path.add(currentNode);
        }
        Collections.reverse(path);
        GeneralPath path2D = new GeneralPath(1);
        ((Path2D)path2D).moveTo(startNode.getLocation().x, startNode.getLocation().y);
        ArrayList<Point2D> pointsOfPath = new ArrayList<Point2D>();
        for (int i = 0; i < path.size(); ++i) {
            AStarNode current = (AStarNode)path.get(i);
            Point currentPoint = new Point(current.getLocation().x, current.getLocation().y);
            pointsOfPath.add(currentPoint);
            ((Path2D)path2D).lineTo(currentPoint.x, currentPoint.y);
        }
        ((Path2D)path2D).lineTo(targetNode.getLocation().x, targetNode.getLocation().y);
        return new Path(startNode.getLocation(), targetNode.getLocation(), path2D, pointsOfPath);
    }
}

