/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.physics.pathfinding;

import de.gurkenlabs.litiengine.environment.tilemap.IMap;
import de.gurkenlabs.litiengine.physics.IPhysicsEngine;
import de.gurkenlabs.litiengine.physics.pathfinding.AStarNode;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class AStarGrid {
    private boolean allowDiagonalMovementOnCorners;
    private final AStarNode[][] grid;
    private final int nodeSize;
    private final IPhysicsEngine physicsEngine;
    private final Dimension size;

    public AStarGrid(IPhysicsEngine physicsEngine, IMap map, int nodeSize) {
        this.physicsEngine = physicsEngine;
        this.size = map.getSizeInPixels();
        this.nodeSize = nodeSize;
        int gridSizeX = this.size.width / nodeSize;
        int gridSizeY = this.size.height / nodeSize;
        this.grid = new AStarNode[gridSizeX][gridSizeY];
        this.populateGrid(gridSizeX, gridSizeY);
    }

    public boolean diagonalMovementOnCorners() {
        return this.allowDiagonalMovementOnCorners;
    }

    public AStarNode[][] getGrid() {
        return this.grid;
    }

    public List<AStarNode> getIntersectedNodes(Rectangle2D rectangle) {
        Point2D.Double start = new Point2D.Double(rectangle.getMinX(), rectangle.getMinY());
        Point2D.Double end = new Point2D.Double(rectangle.getMaxX(), rectangle.getMaxY());
        AStarNode startNode = this.getNodeFromMapLocation(start);
        AStarNode endNode = this.getNodeFromMapLocation(end);
        ArrayList<AStarNode> nodes = new ArrayList<AStarNode>();
        if (startNode == null || endNode == null) {
            return nodes;
        }
        for (int x = startNode.getGridX(); x <= endNode.getGridX(); ++x) {
            for (int y = startNode.getGridY(); y <= endNode.getGridY(); ++y) {
                nodes.add(this.getGrid()[x][y]);
            }
        }
        return nodes;
    }

    public List<AStarNode> getNeighbours(AStarNode node) {
        ArrayList<AStarNode> neighbors = new ArrayList<AStarNode>();
        int x = node.getGridX();
        int y = node.getGridY();
        AStarNode top = this.getNode(x, y - 1);
        AStarNode bottom = this.getNode(x, y + 1);
        AStarNode left = this.getNode(x - 1, y);
        AStarNode right = this.getNode(x + 1, y);
        AStarNode topLeft = this.getNode(x - 1, y - 1);
        AStarNode topRight = this.getNode(x + 1, y - 1);
        AStarNode bottomLeft = this.getNode(x - 1, y + 1);
        AStarNode bottomRight = this.getNode(x + 1, y + 1);
        AStarGrid.addNode(neighbors, top);
        AStarGrid.addNode(neighbors, bottom);
        AStarGrid.addNode(neighbors, right);
        AStarGrid.addNode(neighbors, left);
        this.addDiagonalNode(neighbors, topLeft, top, left);
        this.addDiagonalNode(neighbors, topRight, top, right);
        this.addDiagonalNode(neighbors, bottomLeft, bottom, left);
        this.addDiagonalNode(neighbors, bottomRight, bottom, right);
        return neighbors;
    }

    public AStarNode getNodeFromMapLocation(Point2D point) {
        float percentX = (float)(point.getX() / this.getSize().getWidth());
        float percentY = (float)(point.getY() / this.getSize().getHeight());
        percentX = Math.max(0.0f, Math.min(1.0f, percentX));
        percentY = Math.max(0.0f, Math.min(1.0f, percentY));
        int x = (int)((float)(this.getGrid().length - 1) * percentX);
        int y = (int)((float)this.getGrid()[0].length * percentY);
        return this.getGrid()[x][y];
    }

    public int getNodeSize() {
        return this.nodeSize;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setAllowDiagonalMovementOnCorners(boolean allowDiagonalMovementOnCorners) {
        this.allowDiagonalMovementOnCorners = allowDiagonalMovementOnCorners;
    }

    public void updateWalkable(Rectangle2D rectangle) {
        for (AStarNode node : this.getIntersectedNodes(rectangle)) {
            node.setWalkable(!this.physicsEngine.collides(node.getBounds()));
        }
    }

    private static void addNode(List<AStarNode> neighbors, AStarNode node) {
        if (node != null && node.isWalkable()) {
            neighbors.add(node);
        }
    }

    private void addDiagonalNode(List<AStarNode> neighbors, AStarNode node, AStarNode diagonalNeighbor1, AStarNode diagonalNeighbor2) {
        if (node != null && this.diagonalMovementOnCorners() || node != null && diagonalNeighbor1 != null && diagonalNeighbor1.isWalkable() && diagonalNeighbor2 != null && diagonalNeighbor2.isWalkable()) {
            neighbors.add(node);
        }
    }

    private AStarNode getNode(int x, int y) {
        if (x >= 0 && x < this.getGrid().length && y >= 0 && y < this.getGrid()[0].length) {
            return this.getGrid()[x][y];
        }
        return null;
    }

    private void populateGrid(int gridSizeX, int gridSizeY) {
        for (int x = 0; x < gridSizeX; ++x) {
            for (int y = 0; y < gridSizeY; ++y) {
                Rectangle nodeBounds = new Rectangle(x * this.nodeSize, y * this.nodeSize, this.nodeSize, this.nodeSize);
                this.getGrid()[x][y] = new AStarNode(!this.physicsEngine.collides(nodeBounds), nodeBounds, x, y, 0);
            }
        }
    }
}

