/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.physics;

import de.gurkenlabs.litiengine.Game;
import de.gurkenlabs.litiengine.entities.ICollisionEntity;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.entities.IMobileEntity;
import de.gurkenlabs.litiengine.physics.Force;
import de.gurkenlabs.litiengine.physics.IMovementController;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class MovementController<T extends IMobileEntity>
implements IMovementController<T> {
    private static final double FORCE_APPLY_ACCEPTED_ERROR = 0.1;
    private final List<Force> activeForces = new CopyOnWriteArrayList<Force>();
    private final T mobileEntity;
    private final List<Predicate<T>> movementPredicates = new CopyOnWriteArrayList<Predicate<T>>();
    private final List<Consumer<Point2D>> movedConsumer = new CopyOnWriteArrayList<Consumer<Point2D>>();

    public MovementController(T mobileEntity) {
        this.mobileEntity = mobileEntity;
    }

    @Override
    public void apply(Force force) {
        if (!this.activeForces.contains(force)) {
            this.activeForces.add(force);
        }
    }

    @Override
    public List<Force> getActiceForces() {
        return this.activeForces;
    }

    @Override
    public T getEntity() {
        return this.mobileEntity;
    }

    @Override
    public void onMovementCheck(Predicate<T> predicate) {
        if (!this.movementPredicates.contains(predicate)) {
            this.movementPredicates.add(predicate);
        }
    }

    @Override
    public void update() {
        this.handleForces();
    }

    @Override
    public void onMoved(Consumer<Point2D> cons) {
        this.movedConsumer.add(cons);
    }

    protected void moveEntity(double deltaX, double deltaY) {
        Point2D.Double newLocation = new Point2D.Double(this.getEntity().getLocation().getX() + deltaX, this.getEntity().getLocation().getY() + deltaY);
        Game.getPhysicsEngine().move((IMobileEntity)this.getEntity(), newLocation);
        Point2D.Double delta = new Point2D.Double(deltaX, deltaY);
        for (Consumer<Point2D> cons : this.movedConsumer) {
            cons.accept(delta);
        }
    }

    protected boolean isMovementAllowed() {
        for (Predicate<IEntity> predicate : this.movementPredicates) {
            if (predicate.test(this.getEntity())) continue;
            return false;
        }
        return true;
    }

    private void handleForces() {
        this.activeForces.forEach(x -> {
            if (x.hasEnded()) {
                this.activeForces.remove(x);
            }
        });
        for (Force force : this.activeForces) {
            if (force.cancelOnReached() && force.hasReached((ICollisionEntity)this.getEntity())) {
                force.end();
                continue;
            }
            Point2D collisionBoxCenter = this.getEntity().getCollisionBoxCenter();
            if (collisionBoxCenter.distance(force.getLocation()) < 0.1) {
                double yDelta = (double)this.getEntity().getHeight() - this.getEntity().getCollisionBox().getHeight() + this.getEntity().getCollisionBox().getHeight() / 2.0;
                Point2D.Double entityLocation = new Point2D.Double(force.getLocation().getX() - (double)(this.getEntity().getWidth() / 2.0f), force.getLocation().getY() - yDelta);
                this.getEntity().setLocation(entityLocation);
                continue;
            }
            double angle = GeometricUtilities.calcRotationAngleInDegrees(collisionBoxCenter, force.getLocation());
            boolean success = Game.getPhysicsEngine().move((IMobileEntity)this.getEntity(), (float)angle, (double)((float)Game.getLoop().getDeltaTime() * 0.001f * force.getStrength()));
            if (!force.cancelOnCollision() || success) continue;
            force.end();
        }
    }
}

