/*
 * Decompiled with CFR 0.152.
 */
package de.gurkenlabs.litiengine.physics;

import de.gurkenlabs.litiengine.entities.Direction;
import de.gurkenlabs.litiengine.entities.IEntity;
import de.gurkenlabs.litiengine.physics.Force;
import de.gurkenlabs.litiengine.util.geom.GeometricUtilities;
import java.awt.geom.Point2D;

public class GravityForce
extends Force {
    private final Direction direction;
    private final IEntity forceEntiy;

    public GravityForce(IEntity forceEntity, float strength, Direction dir) {
        super(forceEntity.getDimensionCenter(), strength, 0.0f);
        this.forceEntiy = forceEntity;
        this.direction = dir;
        this.setCancelOnCollision(false);
        this.setCancelOnReached(false);
    }

    public IEntity getForceEntiy() {
        return this.forceEntiy;
    }

    @Override
    public Point2D getLocation() {
        return GeometricUtilities.project(this.getForceEntiy().getDimensionCenter(), Direction.toAngle(this.direction), (double)Math.max(this.forceEntiy.getHeight(), this.forceEntiy.getWidth() * 2.0f + this.getStrength()));
    }
}

